#version 450

mat4 translate(vec3 translateVector) {
    mat4 matrix;
    matrix[0] = vec4(1, 0, 0, 0);
    matrix[1] = vec4(0, 1, 0, 0);
    matrix[2] = vec4(0, 0, 1, 0);
    matrix[3] = vec4(translateVector, 1);
    return matrix;
}

mat4 rotate_x(float angle) {
    float s = sin(angle);
    float c = cos(angle);
    mat4 matrix;
    matrix[0] = vec4(1, 0, 0, 0);
    matrix[1] = vec4(0, c, s, 0);
    matrix[2] = vec4(0, -s, c, 0);
    matrix[3] = vec4(0, 0, 0, 1);
    return matrix;
}

mat4 rotate_y(float angle) {
    float s = sin(angle);
    float c = cos(angle);
    mat4 matrix;
    matrix[0] = vec4(c, 0, s, 0);
    matrix[1] = vec4(0, 1, 0, 0);
    matrix[2] = vec4(-s, 0, c, 0);
    matrix[3] = vec4(0, 0, 0, 1);
    return matrix;
}

mat4 rotate_z(float angle) {
    float s = sin(angle);
    float c = cos(angle);
    mat4 matrix;
    matrix[0] = vec4(c, s, 0, 0);
    matrix[1] = vec4(-s, c, 0, 0);
    matrix[2] = vec4(0, 0, 1, 0);
    matrix[3] = vec4(0, 0, 0, 1);
    return matrix;
}

mat4 rotate(vec3 angle) {
    return rotate_x(angle.x) * rotate_y(angle.y) * rotate_z(angle.z);
}

const float gauss_extrude = 1.0;
//const int gauss_kernel_size = 10;
//float gauss_weight[gauss_kernel_size * 2 + 1] = float[](0.011254, 0.016436, 0.023066, 0.031105, 0.040306, 0.050187, 0.060049, 0.069041, 0.076276, 0.080977, 0.082607, 0.080977, 0.076276, 0.069041, 0.060049, 0.050187, 0.040306, 0.031105, 0.023066, 0.016436, 0.011254);
//float gauss_weight[gauss_kernel_size * 2 + 1] = float[](0.0005,	0.0015,	0.0039,	0.0089,	0.0183,	0.0334,	0.0549,	0.0807,	0.1063,	0.1253,	0.1324,	0.1253,	0.1063,	0.0807,	0.0549,	0.0334,	0.0183,	0.0089,	0.0039,	0.0015,	0.0005);

//const int gauss_kernel_size = 15;
//float gauss_weight[gauss_kernel_size * 2 + 1] = float[](0.0130,	0.0150,	0.0172,	0.0194,	0.0218,	0.0242,	0.0266,	0.0290,	0.0312,	0.0333,	0.0352,	0.0368,	0.0382,	0.0391,	0.0397,	0.0399,	0.0397,	0.0391,	0.0382,	0.0368,	0.0352,	0.0333,	0.0312,	0.0290,	0.0266,	0.0242,	0.0218,	0.0194,	0.0172,	0.0150,	0.0130);

const int gauss_kernel_size = 20;
float gauss_weight[gauss_kernel_size * 2 + 1] = float[]
(0.0003,	0.0004,	0.0007,	0.0012,	0.0019,	0.0029,	0.0044,	0.0064,	0.0090,	0.0124,	0.0166,	0.0216,	0.0274,	0.0337,	0.0404,	0.0470,	0.0532,	0.0587,	0.0629,	0.0655,	0.0665,	0.0655,	0.0629,	0.0587,	0.0532,	0.0470,	0.0404,	0.0337,	0.0274,	0.0216,	0.0166,	0.0124,	0.0090,	0.0064,	0.0044,	0.0029,	0.0019,	0.0012,	0.0007,	0.0004,	0.0003);
