layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal;

layout (location = 2) out vec3 v_ray_eye;
layout (location = 4) out vec3 v_position;

layout (location = 5) out vec3 v_tangent;
layout (location = 7) out vec3 v_light_dir;

layout (set = 0, binding = 0) uniform Uniforms {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    mat4 g_camera_from_world;
    mat4 g_world_from_model;
    float scale;
};

void main() {
    vec3 pos = a_position * scale;
    v_uv = a_uv * scale;
    v_normal = mat3(g_camera_from_model) * a_normal;
    gl_Position = g_projection_from_model * vec4(pos, 1.0);
    v_position = mat3(g_world_from_model) * pos;

    v_tangent = mat3(g_camera_from_model) * a_tangent;

//    v_ray_eye = mat3(g_camera_from_model) * (a_position - vec3(0, 0, 0));
    mat3 inverse_rotation = inverse(mat3(g_camera_from_model));
    v_ray_eye = inverse_rotation * -g_camera_from_model[3].xyz;

    vec3 light_dir = normalize(vec3(0.5, 1, 0.5));
    v_light_dir = light_dir;
//    v_light_dir = mat3(g_camera_from_world) * light_dir;
}