layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal;

layout (set = 0, binding = 0) uniform Uniforms {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    float extrude;
    vec4 vs_param;
};

void main() {
    vec3 pos = a_position  * vec3(1, vs_param.x * 100, 1) + a_normal * extrude * 0.25;
    gl_Position = g_projection_from_model * vec4(pos, 1.0);
    v_uv = a_uv;
    v_normal = (g_camera_from_model * vec4(a_normal, 0.0)).xyz;
}