#version 450

void calculate_ray(mat4 projection_from_camera, mat4 camera_from_world, vec2 uv, out vec3 eye, out vec3 dir) {
    vec2 fov = vec2(1 / projection_from_camera[0][0], 1 / projection_from_camera[1][1]);
    mat3 inverse_rotation = inverse(mat3(camera_from_world));
    eye = inverse_rotation * -camera_from_world[3].xyz;
    dir = inverse_rotation * vec3(uv * fov, 1);
}

float depth_sample_to_z(float z_near, float buffer_value) {
    return z_near / (1 - buffer_value);
}