import numpy as np
from pynput import mouse, keyboard
import time
import random

X0 = 383
X1 = 988
Y0 = 84
Y1 = 555

PAINT = (312, 139)
STAMP = (352, 144)
TEXT = (309, 243)
BRUSH1 = (1015, 170)
BRUSH2 = (1060, 170)
BRUSH3 = (1015, 213)
BRUSH4 = (1060, 213)

BLACK = (404, 578)
WHITE = (505, 578)

DUCK = (1015, 358)
SIZE = (1066, 545)
DOWN = (1036, 408)

m = mouse.Controller()
k = keyboard.Controller()
#m.position()
#m.move(x,y)
#m.click(x,y) #the third argument "1" represents the mouse button
#m.press(x,y) #mouse button press
#m.release(x,y) #mouse button release
time.sleep(1.)

#m.press(mouse.Button.left)
#m.release(mouse.Button.left)


vertices = [
    np.array([.5, .5, 0.5]),
    np.array([.5, -.5, 0.5]),
    np.array([-.5, -.5, 0.5]),
    np.array([-.5, .5, 0.5]),
    np.array([.5, .5, -0.5]),
    np.array([.5, -.5, -0.5]),
    np.array([-.5, -.5, -0.5]),
    np.array([-.5, .5, -0.5]),
]

edges = [
    np.array([0, 1]),
    np.array([1, 2]),
    np.array([2, 3]),
    np.array([3, 0]),
    np.array([4, 5]),
    np.array([5, 6]),
    np.array([6, 7]),
    np.array([7, 4]),
    np.array([0, 4]),
    np.array([1, 5]),
    np.array([2, 6]),
    np.array([3, 7]),
]

def rotx(r):
    return np.array([
        np.array([1, 0, 0]),
        np.array([0, np.cos(r), -np.sin(r)]),
        np.array([0, np.sin(r), np.cos(r)]),
    ])

def roty(r):
    return np.array([
        np.array([np.cos(r), 0, np.sin(r)]),
        np.array([0, 1, 0]),
        np.array([-np.sin(r), 0, np.cos(r)]),
    ])

def rotz(r):
    return np.array([
        np.array([np.cos(r), -np.sin(r), 0]),
        np.array([np.sin(r), np.cos(r), 0]),
        np.array([0, 0, 1]),
    ])

def rot(rx, ry, rz):
    return rotx(rx) @ roty(ry) @ rotz(rz)

#def proj(n, f, t, b, l, r):
    #return np.array(
        #np.array([2*n/(r-l), 0, 0, 0]),
        #np.array([0, 1*n/(t-b), 0, 0]),
        #np.array([(r+l)/(r-l), (t+b)/(t-b), -(f+n)/(f-n), -1]),
        #np.array([0, 0, -(2*f*n)/(f-n), 0])
    #)
#P = proj(0.1, 100., , , 0., 1.)
def proj(a, ar, n, f):
    return np.array([
        np.array([1/(ar*np.tan(a/2)), 0, 0, 0]),
        np.array([0, 1/(np.tan(a/2)), 0, 0]),
        np.array([0, 0, (-n-f)/(n-f), (2*f*n)/n-f]),
        np.array([0, 0, 1, 0]),
    ])

P = proj(30, 1.777, 0.1, 10.)

X = X1 - X0
Y = Y1 - Y0

RIGHT = (1066, 428)
KARKKI = (1060, 267)
KUUSI = (1060, 312)

def joulu():
    m.position = STAMP
    m.click(mouse.Button.left)
    m.position = RIGHT
    for i in range(11):
        m.click(mouse.Button.left)
        time.sleep(0.1)
    m.position = KARKKI
    m.click(mouse.Button.left)
    time.sleep(1)
    m.position = (X0 + 4/5*X, Y0 + 3/5*Y)
    m.click(mouse.Button.left)
    time.sleep(1)
    m.position = KUUSI
    m.click(mouse.Button.left)
    time.sleep(1)
    m.position = (X0 + 3/5*X, Y0 + 2/5*Y)
    m.click(mouse.Button.left)
    time.sleep(1)
    m.position = DOWN
    for i in range(2):
        m.click(mouse.Button.left)
        time.sleep(0.1)
    m.position = DUCK
    m.click(mouse.Button.left)
    time.sleep(1)
    m.position = (X0 + 1/5*X, Y0 + 1/5*Y)
    m.click(mouse.Button.left)
    time.sleep(1)
    m.position = DOWN
    for i in range(4):
        m.click(mouse.Button.left)
        time.sleep(0.1)
    m.position = DUCK
    m.click(mouse.Button.left)
    time.sleep(1)
    m.position = (X0 + 1/5*X, Y0 + 3/5*Y)
    m.click(mouse.Button.left)
    time.sleep(1)
    m.position = (X0 + 2/5*X, Y0 + 3.5/5*Y)
    m.click(mouse.Button.left)
    time.sleep(1)
    m.position = (X0 + 3/5*X, Y0 + 3/5*Y)
    m.click(mouse.Button.left)
    time.sleep(1)
    m.position = RIGHT
    for i in range(6):
        m.click(mouse.Button.left)
        time.sleep(0.1)

    m.position = TEXT
    m.click(mouse.Button.left)
    m.position = WHITE
    m.click(mouse.Button.left)
    m.position = (X0 + 10, Y0 + Y*6.5/8)
    m.click(mouse.Button.left)
    time.sleep(1)
    write_text("Merry F-mas")
    for i in range(5):
        time.sleep(0.3)
        write_letter(keyboard.Key.backspace)
    time.sleep(0.2)
    write_text("X-mas! ")
    time.sleep(1)
    write_letter(keyboard.Key.enter)
    write_text("Now, we go to space!")
    time.sleep(2)
    write_letter(keyboard.Key.enter)



def sine(i):
    m.position = BRUSH1
    m.click(mouse.Button.left)
    m.position = WHITE
    m.click(mouse.Button.left)
    m.position = (X0, Y/2)
    m.press(mouse.Button.left)
    for x in range(X0, X1, 5):
        y = np.sin(x*.02+i) * 50 + Y/2 + Y0
        m.position = (x, y)

    m.release(mouse.Button.left)

def cube(i):
    m.position = BRUSH1
    m.click(mouse.Button.left)
    m.position = WHITE
    m.click(mouse.Button.left)

    for e in edges:
        R = rot(i*.1, 0., i)
        v1 = R @ vertices[e[0]]
        v2 = R @ vertices[e[1]]

        v1[2] += 2
        v2[2] += 2

        # projection
        v1 = P @ np.concatenate((v1, (1.,)),0)
        v2 = P @ np.concatenate((v2, (1.,)),0)

        v1 = v1[:2] / v1[3]
        v2 = v2[:2] / v2[3]

        p1 = np.array((X0, Y0)) + (v1 + 1.)/2. * np.array((X, Y))
        p2 = np.array((X0, Y0)) + (v2 + 1.)/2. * np.array((X, Y))
        print(p1)
        m.position = tuple(p1)
        m.press(mouse.Button.left)
        m.position = tuple(p2)
        m.release(mouse.Button.left)

def stamp():
    m.position = STAMP
    m.click(mouse.Button.left)
    m.position = DOWN
    m.click(mouse.Button.left)
    m.position = DUCK
    m.click(mouse.Button.left)
    time.sleep(4.)
    m.position = SIZE
    m.click(mouse.Button.left)
    m.position = (X0 + X/4*3, Y0 + Y/4*3)
    m.click(mouse.Button.left)
    m.position = RIGHT
    for i in range(11):
        m.click(mouse.Button.left)
        time.sleep(0.1)
    m.position = DOWN
    for i in range(3):
        m.click(mouse.Button.left)
        time.sleep(0.1)
    m.position = DUCK
    m.click(mouse.Button.left)
    time.sleep(1)
    m.position = (912, 317)
    m.click(mouse.Button.left)
    time.sleep(1)

def write_letter(l):
    k.press(l)
    k.release(l)
    time.sleep(0.1)

def write_text(t):
    for l in t:
        write_letter(l)

def greets():
    m.position = TEXT
    m.click(mouse.Button.left)
    m.position = WHITE
    m.click(mouse.Button.left)
    m.position = (414, 106)
    m.click(mouse.Button.left)
    time.sleep(1.)
    write_text("Greetings to JML")
    time.sleep(.5)
    write_letter(keyboard.Key.enter)
    time.sleep(.5)
    write_text("  please come to instansi")
    time.sleep(.5)
    write_letter(keyboard.Key.enter)
    time.sleep(.5)
    write_text("     regards donal duc")
    time.sleep(1.)
    write_letter(keyboard.Key.enter)

def genstar(z = None):
    if z:
        zz = z
    else:
        zz = random.random()*5.
    return np.array([random.random()*2.-1.,
              random.random()*2.-1.,
              zz])

stars = [
]
for i in range(20):
    stars.append(
        genstar()
    )

def starfield(i):
    m.position = BRUSH1
    m.click(mouse.Button.left)
    m.position = WHITE
    m.click(mouse.Button.left)

    for j in range(len(stars)):
        # projection
        s = stars[j]
        s2 = [s[0], s[1], s[2]-.4]
        p1 = P @ np.concatenate((s, (1.,)),0)
        p2 = P @ np.concatenate((s2, (1.,)),0)

        p1 = p1[:2] / p1[3]
        p2 = p2[:2] / p2[3]

        p1 = np.array((X0, Y0)) + (p1 + 1.)/2. * np.array((X, Y))
        p2 = np.array((X0, Y0)) + (p2 + 1.)/2. * np.array((X, Y))

        m.position = tuple(p1)
        if p1[0] > X0 and p1[0] < X1 and p1[1] > Y0 and p1[1] < Y1:
            m.press(mouse.Button.left)
            m.position = tuple(p2)
            m.release(mouse.Button.left)
            s = [] + s2
            if s[2] < 0.:
                stars[j] = genstar(5.)
            else:
                stars[j] = s
        else:
            stars[j] = genstar(5.)

def circle():
    m.position = TEXT
    m.click(mouse.Button.left)
    m.position = WHITE
    m.click(mouse.Button.left)
    m.position = (X0 + 10, Y0 + Y*1/8)
    m.click(mouse.Button.left)
    time.sleep(1)
    write_text("Let's start with something simple")
    time.sleep(2)
    write_letter(keyboard.Key.enter)
    time.sleep(1)

    r = 100.
    m.position = PAINT
    m.click(mouse.Button.left)
    m.position = BRUSH1
    m.click(mouse.Button.left)
    m.position = WHITE
    m.click(mouse.Button.left)
    RG = 100
    for i in range(RG):
        a = i/RG * 2 * 3.14
        m.position = (
            X0 + X/2 + np.cos(a)*r,
            Y0 + Y/2 + np.sin(a)*r,
        )
        if i == 0:
            m.press(mouse.Button.left)
        time.sleep(0.1)
    m.release(mouse.Button.left)
    m.position = TEXT
    m.click(mouse.Button.left)
    m.position = (X0 + X*1/5, Y0 + Y*4/5)
    m.click(mouse.Button.left)
    time.sleep(1)
    write_text("Very cool. ")
    write_letter(keyboard.Key.enter)
    time.sleep(3)
    write_text("But there's more.")
    time.sleep(.6)
    write_letter('.')
    time.sleep(.6)
    write_letter('.')
    write_letter(keyboard.Key.enter)
            



ITERS = 180
for i in range(ITERS):
    time.sleep(0.11)
    m.position = PAINT
    m.click(mouse.Button.left)
    m.position = BRUSH4
    m.click(mouse.Button.left)
    m.position = BLACK
    m.click(mouse.Button.left)
    
    for y in range(Y0, Y1, 10):
        m.position = (X0, y)
        m.press(mouse.Button.left)
        m.position = (X1, y)
        m.release(mouse.Button.left)

    phase = i/ITERS
    if i < 1:
        circle()
        #starfield(i)
    elif phase < 0.3:
        sine(i*.6)
    elif phase < 0.3 + 1/ITERS:
        joulu()
    elif phase < 0.5: 
        starfield(i)
    elif phase < 0.9:
        cube(i)
    else:
        cube(i)
        stamp()
        greets()
        break


