StageCredits = {}
StageCredits.__index = StageCredits

CREDITS={{
    t="The Fantasy Console News Network",
    l="\nThanks you for tuning in\n\nLovely to see you\n\nWe hope you enjoyed!",
}, {
    t='Crew',
    l="Director and Camera Operator\n\njtruk\n\n-\n\nAV and Set Decoration\n\nDave84\n\n-\n\nPico Triangle Code\n\nMantratronic\n\n-\n\nPicowide font idea\n\nLokiStriker",
}, {
    t='Greetings',
    l="Inercia\nField-FX\nByteJammers\nRiFT\nSlipstream\nps\nsuperogue\nZep\nNesbox",        
}, {
    t='Saluting the TCC Class of 2022!',
    l=" \n0xSim\nadr\nalia\nawildbrysen\nbeejay\nbenthor\nbrendan\ndnull\nevolutional\nFarbs\n"
    .. "ghostlevel\ngigabates\ngoleztrol\nHeNeArXn\nivanjoukov\njoeygibson\njtruk\njuni\n"
    .. "koorogi\nleft_adjoint\nLiquidream\nluchak\nlustlion\nmario_afk\nmarqueedesign\n"
    .. "maxotaf\nmdales\nmike\nneauoire\nnewobject\nnihilazo\nnobuh\npancelor\npauljan\n"
    .. "pixelbath\npopolon\nqbi_\nremi\nresevoir\nsbrt\nsellorm\nsergrass\nsntcns\nspook\n"
    .. "tanoxyz\nTruck\nwhatabouttheken\nWillFlux\nwrench\nz303"
}}

function StageCredits:new()
    local o = {}
    setmetatable(o, StageCredits)
    o.blocks = {CreditBlock:new(CREDITS[1])}
    o.thisBlock = 1
    o.isFinished = false
    o.time=0
    return o
end

function StageCredits:update()
    for _,b in pairs(self.blocks) do
        if not b:update() then
            self.thisBlock = self.thisBlock + 1
            if self.thisBlock > #CREDITS then
                self.isFinished = true
            else
                self.blocks[1] = CreditBlock:new(CREDITS[self.thisBlock])
            end
        end
    end
    self.time=self.time+1
    return self.isFinished
end

function StageCredits:draw()
    dCls(6)
    --[[
    local strs={"Tiny Code Christmas", "tcc.lovebyte.party", "LOVEBYTETCC"}
    for i=0,5 do
        local s=strs[i%#strs+1]
        local y=(100-self.time*.3+150/6*i)%150-10
        local w=dPrintW(s)
        local x=SCRWH-w/2+sin(self.time*.0008+i*.63)*80
            +cos(.82+self.time*.0006+i*.39)*80
        dPrint(s, dPMake(x, y), 7)
    end
    --]]
    for _,b in pairs(self.blocks) do
        b:draw()
    end
end
