PI=math.pi
TAU=PI*2
SCRW,SCRH,SCRWH,SCRHH=240,136,120,68
SMULT=1.3
BG_COL=8

MIDX=120
MIDY=68
PLATFORM='t'

OBJSCREEN_W=80
OBJSCREEN_H=60
HOST_F="Katie O'Tic"
HOST_Fs="Katie"
HOST_M="Mick Atee"
HOST_Ms="Mick"
HOST_S="Scienticst"

-- default to PICO-8's 0..1 rather than 0..PI*2
sin=function(a)
    return -math.sin(a*TAU)
end

cos=function(a)
    return math.cos(a*TAU)
end

atan2=function(a,b)
    return (math.atan2(-a,-b)/PI+1)/2
end

sqrt=function(a)
    return math.sqrt(a)
end

min,max,abs=math.min,math.max,math.abs

-- returns the current second of the hour
function getTSync()
    return tstamp()%(60*60)
end

function tblAdd(t, v)
    return table.insert(t, v)
end
  
function tblShift(t)
    return table.remove(t, 1)
end

function tblSort(t, fn)
    return table.sort(t, fn)
end

function flrdiv(a,b)
    return a//b
end

function dFloor(a)
    return math.floor(a)
end

function dCeil(a)
    return math.ceil(a)
end

function dPMake(x,y)
    return {x=x,y=y}
end

-- Multiplies on TIC-80
function dPMakeS(x,y)
    return {x=dFloor(x*SMULT+.5),y=dFloor(y*SMULT+.5)}
end

function dPAdd(p,dx,dy)
    return {x=p.x+dx,y=p.y+dy}
end
  
function dPAddS(p,dx,dy)
    return {x=dCeil(p.x+dx*SMULT),y=dCeil(p.y+dy*SMULT)}
end

function dCls(c)
  cls(c)
end

function dPixSet(p, c)
    pix(p.x,p.y,c)
end

function dPixGet(p, c)
    return pix(p.x,p.y)
end

function dRectF(p,d,c)
    rect(p.x,p.y,d.x,d.y,c)
end

function dElliF(p,d,c)
    elli(p.x,p.y,d.x,d.y,c)
end

function dTriF(p0,p1,p2,c)
    tri(p0.x,p0.y,p1.x,p1.y,p2.x,p2.y,c)
end

-- Takes a string, returns table
function dSplitTextByChar(s, ch)
    local o={}
    local last=1
    for i=1,#s do
      if s:sub(i,i) == ch then
        o[#o+1] = s:sub(last,i-1)
        last=i+1
      end
    end
    if last < #s then
      o[#o+1] = s:sub(last,#s)
    end
    return o
  end
  
  -- Takes a string, returns table
  function dSplitTextByNewlines(s)
    return dSplitTextByChar(s, "\n")
  end
  
  -- Takes a string, returns table
  function dSplitTextBySpaces(s)
    return dSplitTextByChar(s, " ")
  end

function dPrintW(line)
    return print(line,0,140,0)
end

function dPrintH(lines, gutterH)
    local textH = 5
    return #lines * textH + (#lines - 1) * gutterH
  end

-- Print a line of text
function dPrint(l,p,c)
    print(l,p.x,p.y,c)
end

function dBtn(i)
    local sw={2,3,0,1,4,5}
    return btn(sw[i+1])
end

function dBtnP(i)
    local sw={2,3,0,1,4,5}
    return btnp(sw[i+1])
end

function dModfr(x)
    _, r = math.modf(x)
    return r
end

-- Convert to seconds to match PICO-8
function dTime()
    return time()/1000
end

function random(start,range)
    return math.random(start,start+range)
end
  
function dMusic()
    if SOUND_TIC80 then
        music(0,0,0,false)
    end
end

function dSfxChirp(t)
    if SOUND_TIC80 then
        local pitch
        if t == "katie" then
            pitch=random(60,10)
        elseif t == "mick" then
            pitch=random(40,10)
        elseif t == "scientist" then
            pitch=random(30,15)
        elseif t == "ps" then
            pitch=random(35,10)
        end
        sfx(0,pitch,2,0,10)
    end
end