Obj = {}

function Obj:new(o, prims, x,z, isVisible)
    local o = o or {}
    setmetatable(o, self)
    self.__index = self
    o.isVisible = isVisible
    o.tAlive = 0
    -- shift x starting pos a little, for perspective
    o.pos = {x=x,z=z}
    if o.pos.z then -- class constructor can make this nil??
        o.pos.x = o.pos.x * o.pos.z
    end
    o.prims = prims
    return o
end

function Obj:get()
    return {x=self.pos.x}
end

function Obj:speak(text, duration)
    self.speech = {
        text=text,
        duration=duration,
    }
end

function Obj:update()
    self.tAlive = self.tAlive + 1
end

function Obj:draw(camShiftX)
    if not self.isVisible then
        return
    end
    self:_draw(dPMake((self.pos.x + camShiftX)*SMULT + SCRWH, SCRHH+10))
end

function Obj:_draw(pScrO)
    self:_drawPrims(pScrO)
end

function Obj:_drawPrims(pScrO)
    drawPrims(self.prims, pScrO)
end
