CreditBlock = {}
CreditBlock.__index = CreditBlock

function CreditBlock:new(data)
    local o = {}
    setmetatable(o, CreditBlock)
    o.mlTitleText=MLText:new(data.t, MINSCRW*.7, 3)
    o.mlBodyText=MLText:new(data.l, MINSCRW*.7, 3)
    o.y=146
    o.h=o.mlTitleText:getH() + o.mlBodyText:getH() + 60
    o.visible=true
    return o
end

function CreditBlock:update()
    self.y=self.y-.65
    if self.y+self.h+10<0 then
        self.visible=false
    end
    return self.visible
end

function CreditBlock:draw()
    if not self.visible then
        return
    end

    local pBox = dPMake(0, self.y)
    local y1=self.y + self.h - 1
    local pBoxSz = dPMake(SCRW, self.h)
    dRectF(pBox, pBoxSz, 2)
    for x=-10,SCRW+10,20 do
        dTriF(dPMake(x, self.y-10), dPMake(x-10, self.y), dPMake(x+10, self.y), 2)
        dTriF(dPMake(x, y1+10), dPMake(x-10, y1), dPMake(x+10, y1), 2)
    end

    local lineX,lineY=SCRWH, self.y + 20
    local pTitleText=dPMake(lineX,lineY)
    self.mlTitleText:print(dPAdd(pTitleText,1,1), 0, 0)
    self.mlTitleText:print(pTitleText, 12, 0)

    local lineX=SCRWH
    local yTitleGap=15

    local pBodyText=dPMake(lineX,pTitleText.y+yTitleGap)
    self.mlBodyText:print(dPAdd(pBodyText,1,1), 0, 0)
    self.mlBodyText:print(pBodyText, 12, 0)
--[[
    for i=1,#self.lines do
        dPrint(self.lines[i], dPAdd(pLine, 1,1), 0)
        dPrint(self.lines[i], pLine, 12)
    end
    --]]
end