SIDES EQU 6
VECS=SIDES*6
SEEK=64-VECS
BASE EQU BP+4
REGS EQU BASE-VECS
SAX EQU REGS-2
SBX EQU REGS-8
SCX EQU REGS-4
SDX EQU REGS-6
REGS2 EQU REGS-16
SAX2 EQU REGS2-2
SBX2 EQU REGS2-8
SCX2 EQU REGS2-4
SDX2 EQU REGS2-6

ORG 256
 MOV FS,AX		; FS: BIOS variables

 MOV AL,13H		; set video mode 320x200
 INT 10H		; call VGA Bios

 DEC BX
.1:
 XCHG BX,CX
 SHR CL,1
 JNO .2
 MOV CL,63
.2:
 IMUL DX,BX,64
 MOV AX,1010H		; set only one color by the VGA BIOS
 INT 10H		; call VGA Bios
 MOV CX,BX
 LOOP .1

 PUSH WORD 0A050H
 MOV BP,SP		; BP: -4
 POP ES

 POP CX 		; CX:0
.0:
 PUSH CX		; put normal vectors to the stack
 PUSH CX
 PUSH BX		; [SP]: 0 0 1
 PUSH CX
 PUSH BX
 PUSH CX		; [SP]: 0 1 0
 PUSH BX
 PUSH CX
 PUSH CX		; [SP]: 1 0 0
 NEG BX
 JS .0

nextframe:
 MOV SI,46CH
 FILD DWORD [FS:SI]	; time
 FMUL DWORD [SPEED]	; alpha
 FLD ST0		; alpha alpha
 FADD ST1,ST0		; alpha 2alpha

.1:
 MOV DI,SP		; DI: normal vectors
.2:
 FILD WORD [DI+2]	; NY 2a a
 FILD WORD [DI] 	; NZ NY 2a a
 FILD WORD [DI+4]	; NX NZ NY 2a a
.3:
 FLD ST3		; 2a NX NZ NY 2a a
 FSINCOS		; cos sin NX NZ NY 2a a
 FLD ST3		; NZ cos sin NX NZ NY 2a a
 FMUL ST0,ST1		; cosNZ cos sin NX NZ NY 2a a
 FXCH ST4		; NZ cos sin NX cosNZ NY 2a a
 FMUL ST0,ST2		; sinNZ cos sin NX cosNZ NY 2a a
 FXCH ST3		; NX cos sin sinNZ cosNZ NY 2a a
 FMUL ST2,ST0		; NX cos sinNX sinNZ cosNZ NY 2a a
 FMULP ST1,ST0		; cosNX sinNX sinNZ cosNZ NY 2a a
 FSUBRP ST2,ST0 	; sinNX cosNX-sinNZ cosNZ NY 2a a
 FADDP ST2,ST0		; cosNX-sinNZ sinNX+cosNZ NY 2a a
 FSTP DWORD [SI+BP]	; sin*NX+cosNZ NY 2a a
 NEG BP
 JNS .3 		; loop 2x (next axis)
 FSTP DWORD [SI]	; 2a a
 ADD SI,12
 ADD DI,6
 JNZ .2 		; loop 6x (next side)

 FUCOMPP		; -

 MOV CL,192
nextline:
 MOV BX,320
nextpixel:
 PUSHA
 AND CX,31
 SUB CX,16
 AND BX,31
 SUB BX,16
 PUSHA

 FILD DWORD [SPEED]	; BIG
 FLD ST0		; BIG BIG
 FCHS			; max min

 MOV CX,SIDES
nextside:
 SUB SI,12
 FILD WORD [CUBE]	; c max min c
 FLD DWORD [SI+4]	; Nz c max min
 FLDZ			; 0 Nz c max min
 FUCOMIP ST0,ST1	; Nz c max min
 JZ skip		; no intersection

 FLD ST1		; c Nz c max min
 FMUL ST0,ST1		; c*Nz Nz c max min

 FLD ST2		; c c*Nz Nz c max min
 FMUL DWORD [SI+BP]	; c*Nx c*Nz Nz c max min
 FISUBR WORD [SBX2]	; Px-c*Nx c*Nz Nz c max min
 FMUL DWORD [SI+BP]	; Nx*(Px-c*Nx) c*Nz Nz c max min

 FLD ST3		; c Nx*(Px-c*Nx) c*Nz Nz c max min
 FMUL DWORD [SI]	; c*Ny Nx*(Px-c*Nx) c*Nz Nz c max min
 FISUBR WORD [SCX2]	; Py-c*Ny Nx*(Px-c*Nx) c*Nz Nz c max min
 FMUL DWORD [SI]	; Ny*(Py-c*Ny) Nx*(Px-c*Nx) c*Nz Nz c max min

 FADDP ST1,ST0		; Nx*(Px-c*Nx)+Ny*(Py-c*Ny) c*Nz Nz c max min

 FDIVRP ST2,ST0 	; c*Nz (Nx*(Px-c*Nx)+Ny*(Py-c*Ny))/Nz c max min
 FSUBRP ST1,ST0 	; c*Nz-(Nx*(Px-c*Nx)+Ny*(Py-c*Ny))/Nz c max min
 JA front

 FUCOMI ST0,ST3 	; Iz c max min
 FCMOVNB ST0,ST3	; Iz c max min
 FXCH ST3		; Iz c max min
 CMOVB BX,SI
 JMP skip

front:
 FUCOMI ST0,ST2 	; Iz c max min
 FCMOVB ST0,ST2 	; Iz c max min
 FXCH ST2		; Iz c max min
 CMOVNB DI,SI

skip:
 FUCOMPP		; max min
 LOOP nextside

 FUCOMPP
 FNSTSW AX
 SAHF

 FLD DWORD [DI+4]
;FCHS

 FIMUL WORD [MAXCOLOR]
 FISTP WORD [SDX]
 POPA
 POPA
 SALC
 AND AL,DL
 ADD AL,255-222 	; amibient
 STOSB
 DEC BX
 JNZ nextpixel
 LOOP nextline

 IN AL,60H
 DAS
 JC nextframe

RETN			; return to DOS prompt

SPEED DD 0.03125

CUBE DW 9
MAXCOLOR DW -222;255;56;74;94

