#version 120

#define MAX_STEPS 1000
#define MAX_DIST 300.
#define MIN_DIST 0.00001

//uniform vec3 camPos;
//uniform vec3 lookAt;
uniform float iTime;
uniform int holes;
uniform float modulo;

mat3 rotate(float x, float y, float z)
{
    mat3 rotZ = mat3(vec3(cos(z), 	sin(z), 	0.),
                    vec3(-sin(z), 	cos(z), 	0.),
                    vec3(0., 		0., 		1.));
    mat3 rotY = mat3(vec3(cos(y), 0., -sin(y)),
                     vec3(0., 	 1., 0.), 
                     vec3(sin(y), 0., cos(y)));
    mat3 rotX = mat3(vec3(1., 0., 		0.), 
                     vec3(0., cos(x), 	sin(x)),
                     vec3(0., -sin(x), 	cos(x)));
    

    return rotX * rotY * rotZ;
}

float sdfBox(vec3 p, vec3 r)
{
    vec3 q = abs(p) - r;
    
    return length(max(q, 0.)) + min(max(q.x, max(q.y, q.z)), 0.);
}

float sdfCross(vec3 p)
{
    float x = sdfBox(p, vec3(200000., 1., 1.));
    float y = sdfBox(p, vec3(1., 200000., 1.));
    float z = sdfBox(p, vec3(1., 1., 200000));
    
    return min(x, min(y, z));
}

float sdfDiff(float a, float b)
{
    float dist = max(a, -b);
    if (dist > a) return dist;
    
    return a;
}

vec2 map(vec3 p)
{
    float o = 0.; //sdfBox(p, vec3(1.));
    //p += vec3(sin(p.z + p.y) / 6., 0., 0.);//sin(p.x - p.z) / 6.);
    p += vec3(sin(p.y * 16. + iTime) / 128.,sin(p.x * 16. + iTime) / 128., 0.);//sin(p.x + p.y * 8.) / 128.);
    
    p *= rotate(0., 0., iTime / 4.);
    
    float b = 1.;
    //float modulo = 2.;// + iTime / 16.;
    int j = 0;
    
    for (int i = 0; i < holes; i++)
    {
        vec3 d = mod(p * b, modulo) - (modulo / 2.);
        
        b *= 3.;
        vec3 r = 1.0 - 3.0 * abs(d);
        
        float c = sdfCross(r) / b;
        //o = max(o, c);
        
        if (o < c)
        {
            o = c;
            j = i;
        }
    }
    
    return vec2(o, j);
}

vec2 march(vec3 ro, vec3 rd)
{
    vec3 p = vec3(0);
    float travel = 0.;
    float hit = 0.;
    vec2 slask = vec2(0.);

    for (int i = 0; i < MAX_STEPS; i++)
    {
        p = ro + rd * travel;
        slask = map(p);
        hit = slask.x;
        travel += (hit / 2.);
        
        if (abs(hit) <= MIN_DIST)
        {
            break;
        }
        if (travel > MAX_DIST) { break; }
    }
    
    return vec2(travel, slask.y);
}

float marchShadow(vec3 ro, vec3 lightP)
{
    vec3 p = ro;
    float travel = 0.1;
    float hit = 0.;
    
    vec3 pToLight = lightP - ro;
    float maxDist = length(pToLight);
    vec3 rd = normalize(pToLight);
    float o = 1.0;
    
    for (int i = 0; i < MAX_STEPS; i++)
    {
        p = ro + rd * travel;
        hit = map(p).x;
        travel += hit;
        
        o = min(o, 50. * hit / travel);
        
        if (abs(hit) <= MIN_DIST)
        {
            return 0.;
        }
        if (travel > maxDist) { break; }
    }
    
    return o;
}


vec3 getNormal(vec3 p)
{
    vec2 smol = vec2(0.00001, 0);
    float x = map(p + smol.xyy).x - map(p - smol.xyy).x;
    float y = map(p + smol.yxy).x - map(p - smol.yxy).x;
    float z = map(p + smol.yyx).x - map(p - smol.yyx).x;

    return normalize(vec3(x, y, z));
}

/*vec3 phong(vec3 p, vec3 n, vec3 cam, vec3 light, vec3 diffuse, float spec, float shine)
{
    vec3 L = normalize(light - p);
    vec3 C = normalize(cam - p);
    vec3 R = normalize(reflect(-L, n));
    
    float NL = dot(L, n);
    float CR = dot(R, C);
    
    if (NL < 0.) return vec3(0.); //No light reaches surface
    if (CR < 0.) return diffuse * NL; //Light is reflected away from camera

    return min(diffuse * NL + spec * pow(CR, shine), vec3(0.2) * diffuse);
}*/

vec3 phong(vec3 p, vec3 n, vec3 cam, vec3 light, vec3 diffuse, float spec, float shine)
{
    vec3 L = normalize(light - p);
    vec3 C = normalize(cam - p);
    
    float LN = max(0., dot(L, n));
    
    vec3 d = diffuse * LN;
    float s = 0.;
    
    if (LN > 0.)
    {
        vec3 R = -normalize(reflect(L, n));
        s = spec * pow(max(0., dot(R, C)), shine);
    }

    return vec3(d + s);
}

vec3 cartoon(vec3 p, vec3 n, vec3 cam, vec3 light, vec3 diffuse, float spec, float shine)
{
    vec3 L = normalize(light - p);
    vec3 C = normalize(cam - p);
    vec3 H = normalize(L + C);

    float NL = max(0., dot(L, n));
    
    vec3 d = diffuse * floor(NL * 10.) * 0.1;
    float s = 0.;
    
    if (dot(L, n) > 0.) s = spec * pow(max(0., dot(H, n)), shine);
    
    float specLim = 1. * step(0.4, pow(dot(H, n), shine));
    
    return vec3(d + s * specLim);
}

void main()
{

    vec2 uv = gl_TexCoord[0].xy * 2. -1.;
    //uv /= vec2(1920, 1080) * 2. - 1.;
    uv.x *= 1920. / 1080.;


    //vec2 uv = fragCoord/iResolution.xy * 2. - 1.;
    //uv.x *= iResolution.x / iResolution.y;

    vec3 col = vec3(0.);
        
    vec3 lookAt = vec3(0.0, -0.5, 2. + iTime / 4.);
    vec3 camPos = vec3(0.0, 0., -5. - iTime / 4.);
    
    vec3 forward = normalize(lookAt - camPos);
    vec3 right = normalize(vec3(forward.z, 0., -forward.x));
    vec3 up = normalize(cross(forward, right));
    
    float fov = 1080. / 1920.; // iResolution.y / iResolution.x;
    
    vec3 rayOrigin = camPos;
    vec3 rayDir = normalize(forward + fov * uv.x * right + fov * uv.y * up);
    
    vec3 lightPos = camPos + vec3(sin(iTime / 6.) / 6., sin(iTime / 8.) / 6., sin(iTime) / 4. + 0.2);
    
    vec2 slask = march(rayOrigin, rayDir);
    float hit = slask.x;//march(rayOrigin, rayDir);
    vec3 p = rayOrigin + rayDir * hit;
    
    vec3 n = getNormal(p);
    
    vec3 wallCol = vec3(0.);//vec3(sin(p.z * 16.) / 3. + 0.75, cos(p.x * 32.) / 3. + 0.75, sin(p.z * 128.));
    
    if (slask.y == 0.) wallCol = vec3(0.8,0.7,0.5);
    else if (slask.y == 1.) wallCol = vec3(0.5, 1., 0.7);
    else wallCol = vec3(sin(iTime) / 2. + 0.5, cos(iTime + 128.) / 2. + 0.5, sin(iTime * 2.5) / 2. + 0.5);
    
    //col = cartoon(p, n, camPos, lightPos, wallCol, 0.3, 64.);
    col = phong(p, n, camPos, lightPos, wallCol, 0.3, 64.);
    
    float shadow = marchShadow(p, lightPos);
    col *= shadow;
    
    // Output to screen
    gl_FragColor = vec4(col,1.0);
}