'use strict'

let framerateCap = window.framerateCap;
let showDebugInfo = false
let doPerf = false
let gui = null
let renderer = null
let debugTexts = []

let frameTimeGraphData = Array.from({length: 100}, () => 0)
let fpsCount = 0
let fpsCounter = 0
const fpsCountFunction = () => {
    fpsCount = fpsCounter
    fpsCounter = 0
    window.setTimeout(fpsCountFunction, 1000)
}

fpsCountFunction()

let moduleRunStringsIndent = null

window.entities = entitiesMaker()

const bpm = 140
const ticksPerLine = sync.globals.TicksPerLine
const linesPerBeat = sync.globals.LinesPerBeat
const syncs = Object.values(sync.patterns)

const msPerBeat = (1000*60)/bpm
const msPerLine = msPerBeat / linesPerBeat

const instrumentIds = {
    // name: [instrumentId, noteLength, decaySpeed, generatedNoteData]
    'bassdrum':     [2, 30, 0.010, []],
    'snare1':       [3, 10, 0.1, []],
    'snare2':       [4, 10, 0.1, []],
    // 'bass':         [23, 10, 0.1, []],
    // 'longbd':       [14, 10, 0.1, []],
    // 'glitchbd':     [20, 10, 0.1, []],
    // 'glitch1':      [4, 10, 0.1, []],
    // 'glitch2':      [5, 10, 0.1, []],
    // 'glitch3':      [6, 10, 0.1, []],
    // 'dubbd':        [13, 10, 0.1, []],
    // 'dubsnare':     [15, 10, 0.1, []],
}
Object.values(instrumentIds).forEach(instrumentData => {
    const instrumentId = instrumentData[0]
    const noteLength = instrumentData[1]
    const noteDecay = instrumentData[2]

    let lastNoteOnSyncCursor = null
    let value = 0
    let noteOnLength
    for (let i = 0; i < 200*300; ++i) {
        const ms = (i * 10) * (60 / bpm)
        const syncCursor = Math.floor(ms / msPerLine)
        if (syncCursor !== lastNoteOnSyncCursor) {
            lastNoteOnSyncCursor = syncCursor
            const currentLine = syncs[syncCursor]
            if (currentLine && currentLine.notes && !!currentLine.notes.find(note => note && note.Instrument === instrumentId)) {
                noteOnLength = 0
                value = 1
            }
        } else {
            if (noteOnLength++ > noteLength) {
                value = value - noteDecay
            }
        }
        instrumentData[3].push(Math.max(0, Math.min(1, value)))
    }
})
function readInstrumentSync (instrumentName) {
    const instrumentData = instrumentIds[instrumentName]
    const time = Math.floor(currentFrameTime * 100)
    const value = instrumentData[3][time]
    return value
}
/*
{
    instrumentIds['rewind'] = [0, 0, 0, []]
    instrumentIds['!rewind'] = [0, 0, 0, []]
    for (let i = 0; i < 200*300; ++i) {
        const beat = i / 100
        const value = beat >= 340 && beat <  424 ? 1 : 0
        instrumentIds['rewind'][3].push(value)
        instrumentIds['!rewind'][3].push(1-value)
    }
}
*/

let transport = null
let requestAnimationFrameId = null

function requestUpdate () {
    if (!framerateCap) {
        window.cancelAnimationFrame(requestAnimationFrameId)
        requestAnimationFrameId = window.requestAnimationFrame(update)
    } else {
        window.clearTimeout(requestAnimationFrameId)
        requestAnimationFrameId = window.setTimeout(update, 100)
    }
}

function startPressed () {
    transport.setIsPlaying(true, false)
    requestUpdate()
}

for (var i = 0; i < canvasBuffer.data.length; ++i) {
    canvasBuffer.data[i] = 255
}

window.main = function main (audio = window.audio) {
    console.log('Loaded!')

    console.log("                                                                 .")
    console.log("               .                                                 :")
    console.log("  _________    :           ______                                .         ___")
    console.log("  \\      _/____  .__  ___  \\    /_____ ___  _________   _________!______  /  /")
    console.log("_/       Z/   /__| /_/   \\/    //    X/  /__\\     __ \\_/        X/      \\/  /_")
    console.log("|        /     | !/ /     ____/_     /    |     _//___/    __/   |      /    |")
    console.log("|   __    __   |   /   ___     |    /     |_    X/    |    Z/    |  __   __  |")
    console.log("|___Z/----Z/___!__/____Z/      |__________!/__________|\\________/|__Z/---Z/__!")
    console.log("               :    !NE7________/                                !           :")
    console.log("               .                                                 :           .")
    console.log("               o       ////////////////////////////////////      .")
    console.log("               _")
    console.log("               :       mIKUCOm pRESENTs - mUNDANe iNSTITUTe      :")
    console.log("               :                                                 .")
    console.log("               .       ////////////////////////////////////      _")
    console.log("    _________  .                         ________                :__")
    console.log("    \\      _/__:_  ____ ___  ___  ___  __\\    __/________  ___  /  / ________")
    console.log("  _/       Z/   /_/   Z/  /_/   \\/  /_/   ___ /_/       /_/   \\/  /_/  ___  /_")
    console.log("  |        /     |    /    |     \\   |    X/   |   ___   |     \\   |   X/____/")
    console.log("  |   __    __   |   /     |         |    /    |   Z/    |         |   /    \\_")
    console.log("  |___Z/----Z/___|_________|__/\\_____|_________|___/\\____|__/\\_____!_________/")
    console.log("     ._______    !            _____  '    _____:          _____    `")
    console.log("     |      /_  ___  ________|     |_ .__|     |______ __!     |_ ________")
    console.log("     |     /  \\/  /_/  ___  /_     _/_| /_     _/    Z/ /_     _//  ___  /_")
    console.log("     |    /    \\   |   X/____/     | (_/ |     |     /   |     |    Z/____/")
    console.log("     |   /         |______  _|     |_    |     |_   /    |     |_   /    \\_")
    console.log("     |__/___/\\    /_________\\;______/____'______/_______/;______/_________/")
    console.log("              \\____|")

    window.fitScreen()

    const params = new URLSearchParams(window.location.search)

    // if (params.has('nomusic')) {
    //     transport = new Transport(60 * 20)
    // } else {
        transport = new TransportMp3(audio)
    // }

    if (params.has('time')) {
        const time = parseInt(params.get('time')) * 60 / bpm
        transport.seekExact(time)
    }

    let reloadBlocksNoPlay = false
    if (params.has('devserver')) {
        reloadBlocksNoPlay = devserverInit()
    }

    if (params.has('controls')) {
        document.addEventListener('keydown', (event) => {
            const getSpeed = () => {
                if (event.shiftKey) return 1/60
                if (event.altKey) return 4
                return 1
            }
            const noControl = !event.shiftKey&&!event.altKey&&!event.ctrlKey
            if (event.key === ' ') {
                transport.setIsPlaying(!transport.getIsPlaying(), false)
                requestUpdate()
            } else if (noControl && event.key === 'ArrowUp' ) {
                transport.seekExact(0)
                requestUpdate()
            } else if (event.key === 'ArrowLeft' ) {
                transport.seekDelta(-getSpeed())
                requestUpdate()
            } else if (event.key === 'ArrowRight' ) {
                transport.seekDelta(getSpeed())
                requestUpdate()
            } else if (event.key === 'f') {
                openFullscreen()
            }
        })
    } else if (!params.has('dev')) {
        document.addEventListener('keydown', (event) => {
            if (event.key === ' ') {
                transport.setIsPlaying(!transport.getIsPlaying(), false)
                requestUpdate()
            } else if (event.key === 'f') {
                openFullscreen()
            }
        })
        document.addEventListener('click', () => {
            transport.setIsPlaying(true, false)
            requestUpdate()
        })
        canvas.addEventListener('touchstart', () => {
            transport.setIsPlaying(true, false)
            openFullscreen()
            requestUpdate()
        })
    }

    const elDebuggo = document.getElementById('debugStuff')
    if (params.has('dev') && typeof Gui !== 'undefined') {
        gui = new Gui('gui')

        const optionsChildren = []
        const options = [
            {
                text: 'dev',
                type: 'checkbox'
            },
            {
                text: 'devserver',
                type: 'checkbox'
            },
            {
                text: 'nomusic',
                type: 'checkbox'
            },
            {
                text: 'perf',
                type: 'checkbox'
            },
            {
                text: 'capture',
                type: 'checkbox'
            },
            {
                text: 'controls',
                type: 'checkbox'
            },
            {
                text: 'framerateCap',
                type: 'checkbox'
            },
            {
                text: 'time',
                type: 'number'
            }
        ]
        const writeParams = (params) => {
            let paramsString = ''
            params.forEach((value, key) => {
                if (value) paramsString += `${key}=${value}`
                else paramsString += `${key}`
                paramsString += '&'
            })
            paramsString = paramsString.replace(/&$/, '')
            window.location.search = paramsString
        }
        options.forEach(control => {
            if (control.type === 'checkbox') {
                const checkboxElement = document.createElement('input')
                checkboxElement.type = 'checkbox'
                checkboxElement.checked = params.has(control.text)
                checkboxElement.onchange = () => {
                    const params = new URLSearchParams(window.location.search)
                    if (checkboxElement.checked) {
                        params.set(control.text, '')
                    } else {
                        params.delete(control.text)
                    }
                    writeParams(params)
                }
                optionsChildren.push(checkboxElement)
            } else if (control.type === 'number') {
                const numberElement = document.createElement('input')
                numberElement.type = 'number'
                numberElement.value = params.get(control.text)
                numberElement.onchange = () => {
                    const params = new URLSearchParams(window.location.search)
                    if (numberElement.value !== '') {
                        params.set(control.text, numberElement.value)
                    } else {
                        params.delete(control.text)
                    }
                    writeParams(params)
                }
                optionsChildren.push(numberElement)
            }
            if (control.text) {
                const checkboxText = document.createElement('span')
                checkboxText.style.color = '#fff'
                checkboxText.innerHTML = control.text + ' '
                checkboxText.style.marginLeft = '5px'
                checkboxText.style.marginRight = '15px'
                optionsChildren.push(checkboxText)
            }
        })

        showDebugInfo = true

    } else {
        elDebuggo.style = "display:none"
        gui = {
            startWindow: () => { return false },
            endWindow: () => {},
            addHotKey: () => {},
            endFrame: () => {},
        }
    }

    if (params.has('perf')) {
        doPerf = true
    }

    renderer = new Renderer(ctx)

    Object.values(entities).forEach(entity => {
        EntityAccessHelper.fromEntity(entity).init()
    })

    window.ctx.drawImage(overlays.opening, 0, 0)
    if (showDebugInfo) {
        if (!reloadBlocksNoPlay) transport.setIsPlaying(false, true)
        if (params.has('time')) {
            update()
        }
    }
}

let camViewPersp = m4.identity()

function openFullscreen() {
    if (canvas.requestFullscreen) {
        canvas.requestFullscreen()
    } else if (canvas.webkitRequestFullscreen) { /* Safari */
        canvas.webkitRequestFullscreen()
    } else if (canvas.msRequestFullscreen) { /* IE11 */
        canvas.msRequestFullscreen()
    }
}

let firstUpdate = false
let currentFrameTime = 0
let lastFrameTime = 0
let staticTestBoolean = false
let staticTestFloat = 0.5
let staticTestFloat2 = [2, 3]
let staticTestInt = 0
let entityInfoSearchString = ''
let assetInfoType = 'texture'
let assetInfoName = 'default'
async function update () {
    if (!firstUpdate) {
        console.log('Kick out the jams..')
        firstUpdate = true
    }
    fpsCounter++

    if (showDebugInfo && gui.startWindow('Entity Info', null, null, [new GuiText(Object.entries(entities).length.toString())])) {
        const entityData = Object.entries(entities)
            .map(([entityId, entityData]) => { return [entityData.name, entityId, entityData.type + '.' + entityData.subType]})
        const searchedEntityData = entityData.filter(x => x.some(y => y.includes(entityInfoSearchString)))

        gui.addParameter('Search', 'string', entityInfoSearchString, (newValue) => entityInfoSearchString = newValue)
        if (entityInfoSearchString) {
            gui.addText(`${searchedEntityData.length}/${entityData.length} entities`)
        } else {
            gui.addText(`${entityData.length} entities`)
        }
        gui.addBlank()

        if (gui.startScrollableSection(400, 400)) {
            searchedEntityData.forEach(text => {
                gui.addText(text)
                gui.addToggle(text[1], transportOpenEditors.has(text[1]), (newValue) => {
                    if (newValue) {
                        transportOpenEditors.add(text[1])
                    } else {
                        transportOpenEditors.delete(text[1])
                    }
                })
                gui.addBlank()
            })
        }
        gui.endScrollableSection()
    }
    gui.endWindow()

    if (modulesRunStrings) {
        frameTimeGraphData.shift()
        frameTimeGraphData.push(modulesRunStrings[0][2])
    }
    if (showDebugInfo && gui.startWindow('Profiler', null, null, [new GuiText(fpsCount.toFixed(0))])) {
        if (modulesRunStrings) 
            modulesRunStrings.forEach(([indent, name, duration, entityId]) => {
                gui.startHorizontalGroup([15, 50, 35])
                    gui.addText(duration.toFixed(1))
                    gui.addText('  '.repeat(indent) + name)
                    if (entityId === '0') { 
                        gui.addGraph(frameTimeGraphData, {
                            suggestedMax: 100,
                            style: 'line',
                            height: 40,
                            gridLines: true,
                            gridSize: 10,
                        })
                    } else {
                        gui.addButton(entityId, () => {
                            transportOpenEditors.add(entityId)
                        })
                    }
                gui.endHorizontalGroup()
            })
    }
    gui.endWindow()

    if (gui.startWindow('Asset Info')) {
        gui.addOptionInput('_t', assetInfoType, () => {
            return [
                {text:'model', value:'model'},
                {text:'texture', value:'texture'},
            ]
        }, (v) => {
            assetInfoType = v
            assetInfoName = 'default'
        })
        gui.addOptionInput('_n', assetInfoName, () => {
            return assetInfoType === 'model' ? getAllModelsAsOptions() : getAllColorTextureAsOptions()
        }, (v) => assetInfoName = v)
        
        function infoText(a, b) {
            gui.startHorizontalGroup([30, 70])
            gui.addText(a)
            gui.addText(b)
            gui.endHorizontalGroup()
        }

        if (assetInfoType === 'model') {
            const model = getModel(assetInfoName)
            infoText('Verts', String(model.verts.length))
            infoText('Normals', String(model.normals.length))
            infoText('Objects', String(model.objects.length))
            infoText('SubObjects', String(model.objects.reduce((p, c) => p + c.subObjects.length, 0)))
            const tris = model.objects.reduce((p, c) => p + c.subObjects.reduce((p, c) => p+c.tris.length, 0), 0)
            const quads = model.objects.reduce((p, c) => p + c.subObjects.reduce((p, c) => p+c.quads.length, 0), 0)
            infoText('Tris', String(tris))
            infoText('Quads', String(quads))
            infoText('Total Tris', String(tris + quads*2))
            // usage count..
        } else if (assetInfoType === 'texture') {
            const texture = getColorTexture(assetInfoName)
            infoText('Width', String(texture.width))
            infoText('Height', String(texture.height))
            // usage count..
        }
    }
    gui.endWindow()

    if (showDebugInfo && gui.startWindow('Devserver', null, null, [new GuiBlank(devserverState === 'opened' ? [0.25,.75,0.25] : [.75, 0.25, 0.25])])) {
        gui.startHorizontalGroup()
        gui.addText('Connection state')
        gui.addText(devserverState)
        gui.endHorizontalGroup()

        gui.startHorizontalGroup()
        gui.addText('Tx')
            gui.startHorizontalGroup()
            gui.addText(devServerSendCount.toString())
            gui.addPulse([0.25,.75,0.25], [0, 0, 0], devServerLastSendTime)
            gui.endHorizontalGroup()
        gui.endHorizontalGroup()

        gui.startHorizontalGroup()
        gui.addText('Rx')
            gui.startHorizontalGroup()
            gui.addText(devServerReceiveCount.toString())
            gui.addPulse([0.25,.75,0.25], [0, 0, 0], devServerLastReceiveTime)
            gui.endHorizontalGroup()
        gui.endHorizontalGroup()
    }
    gui.endWindow()

    if (showDebugInfo && gui.startWindow('Command History', null, null, [new GuiText(`${undoStack.length}/${redoStack.length}`)])) {
        gui.startHorizontalGroup([50, 50])
            gui.startVerticalGroup()
                gui.addText('Undo stack:')
                for (let i = 0; i < 5; ++i) {
                    if (i < undoStack.length) {
                        if (i !== 4) {
                            gui.addText(undoStack[i].commandType)
                        } else {
                            gui.addText('...')
                        }
                    } else {
                        gui.addBlank()
                    }
                }
            gui.endVerticalGroup()
            gui.startVerticalGroup()
                gui.addText('Redo stack:')
                for (let i = 0; i < 5; ++i) {
                    if (i < redoStack.length) {
                        if (i !== 4) {
                            gui.addText(redoStack[i].commandType)
                        } else {
                            gui.addText('...')
                        }
                    } else {
                        gui.addBlank()
                    }
                }
            gui.endVerticalGroup()
        gui.endHorizontalGroup()
    }
    gui.endWindow

    // gui.addHotKey('z', ['ctrl'], () => specialTime = window.performance.now())
    gui.addHotKey('s', ['ctrl'], () => {
        renderer.saveImage()
    })
    gui.addHotKey(' ', [], () => {
        transport.setIsPlaying(!transport.getIsPlaying(), true)
    })
    gui.addHotKey(' ', ['shift'], () => {
        transport.setIsPlaying(!transport.getIsPlaying(), false)
    })
    const getSeekSpeed = (modifiers) => {
        if (modifiers.includes('alt')) return 1/60
        if (modifiers.includes('shift')) return 3/4*4
        return 3/4
    }

    gui.addHotKey('ArrowUp', [], () => transport.seekExact(0))
    gui.addHotKey('ArrowLeft', null, (modifiers) => transport.seekDelta(-getSeekSpeed(modifiers)))
    gui.addHotKey('ArrowRight', null, (modifiers) => transport.seekDelta(+getSeekSpeed(modifiers)))

    gui.addHotKey('z', ['ctrl'], () => undoCommand())
    gui.addHotKey('y', ['ctrl'], () => redoCommand())

    transport.update()

    const frameTime = transport.getCurrentTime() / 60 * bpm // + 0.5 // sync fix?
    currentFrameTime = frameTime

    // Update all devices
    Object.entries(entities)
        .filter(([uuid, entity]) => entity.type === 'device')
        .map(([uuid, entity]) => EntityAccessHelper.fromUuid(uuid))
        .filter(eah => eah.staticConfig.enabled)
        .forEach(eah => eah.actions.update(eah.self, eah.staticConfig))

    // Render everything through the transport
    renderer.startFrame()
    modulesRunStrings = []
    moduleRunStringsIndent = 0
    {
        const eah = EntityAccessHelper.fromUuid('0')
        eah.actions.render(
            eah.self,
            frameTime,
            eah.combinedConfigs(frameTime),
            // eah.combinedConfigs(Math.floor(frameTime)), TODO UGH!!
            ctx)
    }
    renderer.endFrame()
    if (showDebugInfo) {
        ctx.globalAlpha = 1.0
        ctx.globalCompositeOperation = 'source-over'
        ctx.font = 'bold 32px sans-serif'
        let y = 10
        debugTexts.forEach(debugText => {
            const text = debugText
            ctx.textAlign = 'start'
            ctx.textBaseline = 'top'
            ctx.strokeStyle = '#000'
            ctx.strokeText(text, 10, y)
            ctx.fillStyle = '#fff'
            ctx.lineWidth = 8
            ctx.fillText(text, 10, y)
            y += 35
        })
    }
    debugTexts = []
    if (gui.startWindow('Render Stats')) {
        const renderStats = Object.entries(renderer.getRenderStats()).forEach(([name, value]) => {
            gui.startHorizontalGroup([70, 30])
            gui.addText(name)
            gui.addText(value.toString())
            gui.endHorizontalGroup()
        })
    }
    gui.endWindow()

    if (showDebugInfo && gui.startWindow('MIDI Log', 700, null, [new GuiPulse([.25, .75, .25], [.0, .0, .0], midiLogLastTime, 1000)])) {
        gui.addText(midiLog)
    }
    gui.endWindow()

    if (showDebugInfo) {
        let entityWasDeleted = false
        transportOpenEditors.forEach(entityId => {
            const entity = entities[entityId]
            if (entity) {
                const entityType = entity.type
                const entitySubType = entity.subType
                if (entityType === 'system' && entitySubType === 'transport') {
                    transportEditor(entityId, frameTime)
                } else {
                    genericEditor(entityId, frameTime)
                }
            } else {
                entityWasDeleted
            }
        })
        if (entityWasDeleted) {
            transportOpenEditors = new Set([...transportOpenEditors].filter(entity => entities[entity] !== undefined))
        }
    }

    // if (transport.getIsPlaying()) {
    //     const startTime = window.performance.now()
    //     modulesRunStrings = []
    //     resetBuffers()
    //     resetBufferLocks()
    //     setOutputBufferId(lockBuffer())
    //     await runModules(frameTime, script)
    //     const endTime = window.performance.now()

    //     if (doPerf) {
    //         let renderTimings = []
    //         for (let i = 0; i < 50; ++i) {
    //             modulesRunStrings = []
    //             resetBuffers()
    //             resetBufferLocks()
    //             setOutputBufferId(lockBuffer())
    //             const startTime = window.performance.now()
    //             await runModules(frameTime, script)
    //             const endTime = window.performance.now()
    //             const renderTime = endTime - startTime
    //             renderTimings.push(renderTime)
    //         }
    //         const min = Math.min(...renderTimings)
    //         const max = Math.max(...renderTimings)
    //         renderTimings = renderTimings.filter(x => !(x === min || x === max))
    //         console.log('Max:', max.toFixed(2))
    //         console.log('Min:', min.toFixed(2))
    //         console.log('Filtered avg:', (renderTimings.reduce((p, c) => p + c, 0) / renderTimings.length).toFixed(2))
    //     }

    //     if (showDebugInfo) {
    //         //if (isDevSectionVisible('Transport')) {
    //             const newFrameTime = window.performance.now()
    //             const totalFrameTime = newFrameTime - lastFrameTime
    //             lastFrameTime = newFrameTime
    //             const fps = 1000 / totalFrameTime
                // const debugText = 'BEAT: ' + frameTime.toFixed(2) + '\n' +
    //                 (endTime - startTime).toFixed(2) + 'ms\n' +
    //                 fps.toFixed(2) + 'fps\n' +
                    // (transport.getIsPlaying() ? 'PLAYING' : 'PAUSED') + '\n'
    //             // document.getElementById('transportText').innerText = debugText
    //         //}

    //         //if (isDevSectionVisible('Modules')) {
    //             // document.getElementById('moduleText').innerText = modulesRunStrings.join('\n')
    //         //}
    //         if (gui.startWindow('Modules')) {
    //             gui.addText(modulesRunStrings)
    //         }
    //         gui.endWindow()



    //         // if (isDevSectionVisible('Syncs')) {
    //         // }
            if (gui.startWindow('Syncs')) {
                showTimelines(frameTime)
                gui.addUserCanvas(timelineCanvas)
            }
            gui.endWindow()
    //     }
    // }

    gui.endFrame()
    updateCommands()

    // if (transport.getIsPlaying()) {
        requestUpdate()
    // }
}

let timelineCanvas = null
let timelineCanvasCtx = null
let timelineCanvasBuffer = 0
function showTimelines (frameTime) {
    const numRows = Object.values(instrumentIds).length
    const rowHeight = 13
    const width = 320
    const height = numRows*rowHeight
    const playHeadY = width * 0.25

    if (!timelineCanvasCtx) {
        timelineCanvas = document.createElement('canvas')
        timelineCanvas.width = width
        timelineCanvas.height = height
        timelineCanvasCtx = timelineCanvas.getContext('2d', { alpha: false })
        timelineCanvasBuffer = timelineCanvasCtx.createImageData(width, height)
        for (var i = 0; i < timelineCanvasBuffer.data.length; ++i) {
            timelineCanvasBuffer.data[i] = 255
        }
    }

    // clear background
    let index = 0
    for (let i = 0; i < width * height; ++i) {
        timelineCanvasBuffer.data[index++] = 0
        timelineCanvasBuffer.data[index++] = 0
        timelineCanvasBuffer.data[index++] = 0
        index++
    }

    // syncs
    const syncsOffset = Math.floor(frameTime * 100 - playHeadY)
    let instrumentRow = 0
    Object.values(instrumentIds).forEach(instrumentData => {
        for (let x = 0; x < width; ++x) {
            const syncValue = instrumentData[3][syncsOffset + x]
            const syncHeight = Math.floor(syncValue * (rowHeight-2)) + 1
            index = (x + width*(rowHeight*(instrumentRow+1)-1)) * 4
            for (let y = 0; y < syncHeight; ++y) {
                timelineCanvasBuffer.data[index++] = 150
                timelineCanvasBuffer.data[index++] = 150
                timelineCanvasBuffer.data[index++] = 150
                index -= width*4 + 3
            }
        }
        ++instrumentRow
    })

    // bars and beats
    let beatPos = playHeadY - Math.floor((frameTime % 3) * 100)
    let beat = 0
    while (true) {
        if (beatPos >= width) break
        if (beatPos >= 0) {
            index = beatPos * 4
            const colour = beat === 0 ? 250 : 150
            for (let i = 0; i < height; ++i) {
                timelineCanvasBuffer.data[index++] = colour
                timelineCanvasBuffer.data[index++] = colour
                index += (width*4)-2
            }
        }
        beatPos += 100
        beat = (beat + 1) % 3
    }

    // playhead
    index = playHeadY*4
    for (let i = 0; i < height; ++i) {
        timelineCanvasBuffer.data[index++] = 250
        timelineCanvasBuffer.data[index++] = 50
        timelineCanvasBuffer.data[index++] = 50
        index += (width*4)-3
    }
    
    // copy to canvas
    timelineCanvasCtx.putImageData(timelineCanvasBuffer, 0, 0)

    // sync names
    timelineCanvasCtx.font = `${rowHeight}px sans-serif`
    timelineCanvasCtx.fillStyle = '#fff'
    timelineCanvasCtx.textAlign = 'start'
    timelineCanvasCtx.textBaseline = 'top'
    let textPos = 0
    Object.keys(instrumentIds).forEach(instrumentId => {
        timelineCanvasCtx.fillText(instrumentId, 0, textPos)
        textPos += rowHeight
    })
}
