'use strict'

entityRegistry['module']['threeDeePlane'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'texture', displayName: 'Texture', type: 'colorTexture', defaultValue: ''},
        { paramName: 'position', displayName: 'Position', type: 'float3', defaultValue: [0, 0, 0]},
        { paramName: 'rotation', displayName: 'Rotation', type: 'angle3', defaultValue: [0, 0, 0]},
        { paramName: 'scale', displayName: 'Scale', type: 'float2', defaultValue: [1, 1]},
        { paramName: 'txTopLeft', displayName: 'Top Left', type: 'float2', defaultValue: [0, 0]},
        { paramName: 'txBottomRight', displayName: 'Bottom Right', type: 'float2', defaultValue: [1, 1]},
        { paramName: 'color', displayName: 'Color', type: 'color', defaultValue: [1, 1, 1]},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                texture,
                position,
                rotation,
                scale,
                txTopLeft,
                txBottomRight,
                color
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            const xRotationMat = m4.xRotation(rotation[0])
            const yRotationMat = m4.yRotation(rotation[1])
            const zRotationMat = m4.zRotation(rotation[2])
            const rotationMat = m4.multiply(m4.multiply(zRotationMat, yRotationMat), xRotationMat)
            const scaleMat = m4.scaling(scale[0], scale[1], 1)
            const translationMat = m4.translation(position[0], position[1], position[2])
            const worldMat = m4.multiply(translationMat, m4.multiply(rotationMat, scaleMat))
            
            const colorId = renderer.getPaletteId(color, color)
            const txMiddle = [(txTopLeft[0] + txBottomRight[0]) / 2, (txTopLeft[1] + txBottomRight[1]) / 2]

            const transformedVerts = renderer.transformVerts(worldMat, [
                [-.5, -.5, 0], [0, -.5, 0], [+.5, -.5, 0],
                [-.5, 0, 0], [0, 0, 0], [+.5, 0, 0],
                [-.5, +.5, 0], [0, +.5, 0], [+.5, +.5, 0],

            ])
            const texCoords = [
                [txBottomRight[0],txTopLeft[1]], [txMiddle[0],txTopLeft[1]], [txTopLeft[0],txTopLeft[1]],
                [txBottomRight[0],txMiddle[1]], [txMiddle[0],txMiddle[1]], [txTopLeft[0],txMiddle[1]],
                [txBottomRight[0],txBottomRight[1]], [txMiddle[0],txBottomRight[1]], [txTopLeft[0],txBottomRight[1]],
            ]
            const tris = [
                [0, 1, 3], [1, 4, 3],
                [1, 2, 4], [4, 2, 5],
                [3, 4, 6], [7, 6, 4],
                [4, 5, 7], [8, 7, 5],
            ]
            tris.forEach(tri => {
                renderer.clipDrawTri_Cull_Depth_Textured(
                    colorBuffer.data,
                    depthBuffer.data,
                    brightnessBuffer.data,
                    transformedVerts[tri[0]],
                    transformedVerts[tri[1]],
                    transformedVerts[tri[2]],
                    texCoords[tri[0]],
                    texCoords[tri[1]],
                    texCoords[tri[2]],
                    texture,
                    colorId,
                    1
                )
            })
        }
    }
}
