'use strict'

entityRegistry['module']['threeDeeModelRepeats'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'model', displayName: 'Model', type: 'model', defaultValue: ''},
        { paramName: 'position', displayName: 'Position', type: 'float3', defaultValue: [0, 0, 0]},
        { paramName: 'rotation', displayName: 'Rotation', type: 'angle3', defaultValue: [0, 0, 0]},
        { paramName: 'scale', displayName: 'Scale', type: 'float3', defaultValue: [0, 0, 0]},
        { paramName: 'repeats', displayName: 'Repeats', type: 'int', defaultValue: 0},
        { paramName: 'repeatTranslation', displayName: 'Repeat Translation', type: 'float3', defaultValue: [0, 0, 2]},
        { paramName: 'repeatRotation', displayName: 'Repeat Rotation', type: 'angle3', defaultValue: [0, 0, 0]},
        { paramName: 'overrideColors', displayName: 'Override Colors', type: 'boolean', defaultValue: false},
        { paramName: 'diffuse', displayName: 'Diffuse', type: 'color', defaultValue: [1, .8, 0]},
        { paramName: 'emissive', displayName: 'Emissive', type: 'color', defaultValue: [0, .1, 0]},
        { paramName: 'diffuseStep', displayName: 'Diffuse Step', type: 'color', defaultValue: [.8, 0, .1]},
        { paramName: 'emissiveStep', displayName: 'Emissive Step', type: 'color', defaultValue: [.01, 0, 0]},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                model,
                position,
                rotation,
                scale,
                repeats,
                repeatTranslation,
                repeatRotation,
                overrideColors,
                diffuse,
                emissive,
                diffuseStep,
                emissiveStep,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            const xRotationMat = m4.xRotation(rotation[0])
            const yRotationMat = m4.yRotation(rotation[1])
            const zRotationMat = m4.zRotation(rotation[2])
            const coreRotationMat = m4.multiply(m4.multiply(zRotationMat, yRotationMat), xRotationMat)
            const coreScaleMat = m4.scaling(scale[0], scale[1], scale[2])

            for (let i = -repeats; i <= +repeats; ++i) {
                const translationMat = m4.translation(
                    position[0] + repeatTranslation[0]*i,
                    position[1] + repeatTranslation[1]*i,
                    position[2] + repeatTranslation[2]*i,
                )
                const xRotationMat = m4.xRotation(repeatRotation[0]*i)
                const yRotationMat = m4.yRotation(repeatRotation[1]*i)
                const zRotationMat = m4.zRotation(repeatRotation[2]*i)
                const rotationMat = m4.multiply(m4.multiply(zRotationMat, yRotationMat), xRotationMat)
                const modelMat = m4.multiply(m4.multiply(coreScaleMat, coreRotationMat), m4.multiply(translationMat, rotationMat))
                
                const objectEmissive = [emissive[0]+emissiveStep[0]*i,emissive[1]+emissiveStep[1]*i,emissive[2]+emissiveStep[2]*i]
                const objectDiffuse = [diffuse[0]+diffuseStep[0]*i,diffuse[1]+diffuseStep[1]*i,diffuse[2]+diffuseStep[2]*i]
                const colorId = overrideColors ? renderer.getPaletteId(objectEmissive, objectDiffuse) : undefined
                renderer.drawModel(model, modelMat, colorBuffer, depthBuffer, brightnessBuffer, colorId)
            }
        }
    }
}
