'use strict'

entityRegistry['module']['stretch'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'position', displayName: 'Position', type: 'float', defaultValue: 0.5, uiOptions: { min: 0, max: 1, scrollScales: [0.01, 0.1, 1] }},
        { paramName: 'direction', displayName: 'Direction', type: 'string', defaultValue: 'd', uiOptions: { options: [{text:'Up',value:'u'}, {text:'Down',value:'d'}, {text:'Left',value:'l'}, {text:'Right',value:'r'}]}},
        { paramName: 'fade', displayName: 'Fade', type: 'float', defaultValue: -0.1, uiOptions: { min: -1, max: 1, scrollScales: [0.01, 0.1, 1] }},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                position,
                direction,
                fade,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')
            const scaledFade = fade / 10

            if (direction === 'r') {
                const startRow = Math.floor(clamp(position, 0, 1) * (colorBuffer.width-1))
                for (let y = 0; y < colorBuffer.height; ++y) {
                    let yIndex = y * colorBuffer.width
                    const color = colorBuffer.data[yIndex + startRow]
                    let brightness = brightnessBuffer.data[yIndex + startRow]
                    for (let y = startRow; y < colorBuffer.width; ++y) {
                        colorBuffer.data[yIndex + y] = color
                        brightnessBuffer.data[yIndex + y] = brightness
                        brightness = Math.max(0, brightness - scaledFade)
                    }
                }
            } else if (direction === 'l') {
                const startRow = Math.floor(clamp(1-position, 0, 1) * (colorBuffer.width-1))
                for (let y = 0; y < colorBuffer.height; ++y) {
                    let yIndex = y * colorBuffer.width
                    const color = colorBuffer.data[yIndex + startRow]
                    let brightness = brightnessBuffer.data[yIndex + startRow]
                    for (let y = startRow; y >= 0; --y) {
                        colorBuffer.data[yIndex + y] = color
                        brightnessBuffer.data[yIndex + y] = brightness
                        brightness = Math.max(0, brightness - scaledFade)
                    }
                }
            }  else if (direction === 'd') {
                const startLine = Math.floor(clamp(position, 0, 1) * (colorBuffer.height-1))
                const stride = colorBuffer.width
                for (let x = 0; x < stride; ++x) {
                    let index = startLine * stride + x
                    const color = colorBuffer.data[index]
                    let brightness = brightnessBuffer.data[index]
                    index += stride
                    for (; index < colorBuffer.height*stride; index += stride) {
                        colorBuffer.data[index] = color
                        brightnessBuffer.data[index] = brightness
                        brightness = Math.max(0, brightness - scaledFade)
                    }
                }
            }  else if (direction === 'u') {
                const startLine = Math.floor(clamp(1-position, 0, 1) * (colorBuffer.height-1))
                const stride = colorBuffer.width
                for (let x = 0; x < stride; ++x) {
                    let index = startLine * stride + x
                    const color = colorBuffer.data[index]
                    let brightness = brightnessBuffer.data[index]
                    index -= stride
                    for (; index > 0; index -= stride) {
                        colorBuffer.data[index] = color
                        brightnessBuffer.data[index] = brightness
                        brightness = Math.max(0, brightness - scaledFade)
                    }
                }
            }
        }
    }
}
