'use strict'

entityRegistry['module']['rendererControl'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'brightness', displayName: 'Brightness', type: 'float', defaultValue: 1},
        { paramName: 'contrast', displayName: 'Contrast', type: 'float', defaultValue: 1},
        { paramName: 'saturation', displayName: 'Saturation', type: 'float', defaultValue: 1},
        { paramName: 'sepia', displayName: 'Sepia', type: 'float', defaultValue: 0},
        { paramName: 'order', displayName: 'Order', type: 'string', defaultValue: 'bcsp'},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                brightness,
                contrast,
                saturation,
                sepia,
                order
            } = { ...config }
 
            const brightnessText = `brightness(${brightness})`
            const contrastText = `contrast(${contrast})`
            const saturationText = `saturate(${saturation})`
            const sepiaText = `sepia(${sepia})`

            let filterText = ''
            for (let i in order) {
                const c = order[i]
                if (c === 'b') filterText += brightnessText
                else if (c === 'c') filterText += contrastText
                else if (c === 's') filterText += saturationText
                else if (c === 'p') filterText += sepiaText
                filterText += ' '
            }

            const canvas = document.getElementById('canvas')
            canvas.style.filter = filterText
        }
    }
}
