'use strict'

entityRegistry['module']['noise'] = {
    init: () => {
        const noise = []
        const rng = new Math.seedrandom()
        for (let i = 0; i < 640*480*2; ++i) {
            noise.push(rng())
        }
        return {
            noise
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'strength', displayName: 'Strength', type: 'float', defaultValue: 1},
        { paramName: 'imageMask', displayName: 'Image Mask', type: 'colorTexture', defaultValue: ''},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                strength,
                imageMask,
            } = { ...config }

            const brightnessBuffer = renderer.getCurrentBuffer('brightness').data
            const maskImage = imageMask.data

            const rng = new Math.seedrandom()
            let srcIndex = Math.floor((rng() * self.noise.length) % self.noise.length)
            let dstIndex = 0
            for (let y = 0; y < 480; ++y) {
                for (let x = 0; x < 640; x++) {
                    if (brightnessBuffer[dstIndex] > 0) {
                        const pixelStrength = strength * maskImage[dstIndex*4+3]/255
                        if (pixelStrength > 0) {
                            brightnessBuffer[dstIndex] += self.noise[srcIndex] * pixelStrength
                            srcIndex = (srcIndex+1) % self.noise.length
                        }
                    }
                    dstIndex++
                }
            }
        }
    }
}
