'use strict'

entityRegistry['module']['mirror'] = {
    init: (staticConfig) => {
         return {
         }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'mode', displayName: 'Mode', type: 'string', defaultValue: 'xy', uiOptions: { options: [{text:'X',value:'x'}, {text:'Y',value:'y'}, {text:'XY',value:'xy'}]}},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                mode,
            } = { ...config }

            function doBufferY (bufferName) {
                const srcBufferId = renderer.getCurrentBufferId(bufferName)
                const dstBufferId = renderer.lockBuffer(bufferName)
                const srcBuffer = renderer.getBufferFromId(bufferName, srcBufferId).data
                const dstBuffer = renderer.getBufferFromId(bufferName, dstBufferId).data
                for (let y = 0; y < 240; ++y) {
                    let iSrc = y*640
                    let iDst = (480-1-y)*640
                    for (let x = 0; x < 640; ++x) {
                        const v = srcBuffer[iSrc]
                        dstBuffer[iSrc] = v
                        dstBuffer[iDst] = v
                        iSrc++
                        iDst++
                    }
                }
                renderer.unlockBuffer(bufferName, srcBufferId)
                renderer.setCurrentBufferId(bufferName, dstBufferId)
            }

            function doBufferX (bufferName) {
                const srcBufferId = renderer.getCurrentBufferId(bufferName)
                const dstBufferId = renderer.lockBuffer(bufferName)
                const srcBuffer = renderer.getBufferFromId(bufferName, srcBufferId).data
                const dstBuffer = renderer.getBufferFromId(bufferName, dstBufferId).data
                for (let y = 0; y < 480; ++y) {
                    let iSrc = y*640
                    let iDst = iSrc+640-1
                    for (let x = 0; x < 320; ++x) {
                        const v = srcBuffer[iSrc]
                        dstBuffer[iSrc] = v
                        dstBuffer[iDst] = v
                        iSrc++
                        iDst--
                    }
                }
                renderer.unlockBuffer(bufferName, srcBufferId)
                renderer.setCurrentBufferId(bufferName, dstBufferId)
            }

            function doBufferXY (bufferName) {
                const srcBufferId = renderer.getCurrentBufferId(bufferName)
                const dstBufferId = renderer.lockBuffer(bufferName)
                const srcBuffer = renderer.getBufferFromId(bufferName, srcBufferId).data
                const dstBuffer = renderer.getBufferFromId(bufferName, dstBufferId).data
                for (let y = 0; y < 240; ++y) {
                    let iSrc = y*640
                    let iDst1 = iSrc+640-1
                    let iDst2 = (480-1-y)*640
                    let iDst3 = iDst2+640-1
                    for (let x = 0; x < 320; ++x) {
                        const v = srcBuffer[iSrc]
                        dstBuffer[iSrc++] = v
                        dstBuffer[iDst1--] = v
                        dstBuffer[iDst2++] = v
                        dstBuffer[iDst3--] = v
                    }
                }
                renderer.unlockBuffer(bufferName, srcBufferId)
                renderer.setCurrentBufferId(bufferName, dstBufferId)
            }

            if (mode === 'x') {
                doBufferX('color')
                doBufferX('brightness')
                doBufferX('depth')
                } else if (mode === 'y') {
                doBufferY('color')
                doBufferY('brightness')
                doBufferY('depth')
            } else {
                doBufferXY('color')
                doBufferXY('brightness')
                doBufferXY('depth')
                }
        }
    }
}
