'use strict'

entityRegistry['module']['lighting'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'ambientStrength', displayName: 'Ambient Strength', type: 'float', defaultValue: 1},
        { paramName: 'enable1', displayName: 'Enable 1', type: 'boolean', defaultValue: false},
        { paramName: 'direction1', displayName: 'Direction 1', type: 'float3', defaultValue: [0,1,0]},
        { paramName: 'strength1', displayName: 'Strength1', type: 'float', defaultValue: 1},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                ambientStrength,
                enable1,
                direction1,
                strength1,
            } = { ...config }

            renderer.setAmbientLight(ambientStrength)
            if (enable1) {
                renderer.addLight(direction1, strength1)
            }
        }
    }
}
