'use strict'

entityRegistry['module']['dust'] = {
    init: (staticConfig) => {
        const {
            seed,
            numMotes,
            fieldSize,
        } = { ...staticConfig }
        const rng = new Math.seedrandom(seed)
        const motes = []
        for (let i = 0; i < numMotes; ++i) {
            const x = rng()
            const y = rng()
            const a = i/(numMotes-1)
            const points = []
            for (let j = 0; j < 5; ++j) {
                const newPoint = [(rng()-.5)*2,(rng()-.5)*2]
                points.push(newPoint)
            }
            motes.push([x, y, a, points])
        }
        return {
            motes
        }
    },
    staticConfig: [
        { paramName: 'seed', displayName: 'Seed', type: 'string', defaultValue: 'seed', triggerInit: true },
        { paramName: 'numMotes', displayName: 'Motes', type: 'int', defaultValue: 100, triggerInit: true },
        { paramName: 'fieldSize', displayName: 'Field Size', type: 'int', defaultValue: 100, triggerInit: true },
    ],
    dynamicConfig: [
        { paramName: 'blitMode', displayName: 'Blit Mode', type: 'string', defaultValue: 'set', uiOptions: { options: [{text:'Set',value:'set'}, {text:'Additive',value:'add'}, {text:'Subtractive',value:'sub'}]}},
        { paramName: 'movePosition', displayName: 'Move Position', type: 'float', defaultValue: 0 },
        { paramName: 'moveHeading', displayName: 'Move Heading', type: 'angle', defaultValue: 0 },
        { paramName: 'minColor', displayName: 'Min Color', type: 'color', defaultValue: [1,0,0] },
        { paramName: 'maxColor', displayName: 'Max Color', type: 'color', defaultValue: [0,1,0] },
        { paramName: 'minSize', displayName: 'Min Size', type: 'float', defaultValue: 1 },
        { paramName: 'maxSize', displayName: 'Max Size', type: 'float', defaultValue: 5 },
        { paramName: 'minSpeed', displayName: 'Min Speed', type: 'float', defaultValue: 1 },
        { paramName: 'maxSpeed', displayName: 'Max Speed', type: 'float', defaultValue: 5 },
        { paramName: 'minPointSpeed', displayName: 'Min Point Speed', type: 'float', defaultValue: 1 },
        { paramName: 'maxPointSpeed', displayName: 'Max Point Speed', type: 'float', defaultValue: 5 },
        { paramName: 'minPointScale', displayName: 'Min Point Scale', type: 'float', defaultValue: 1 },
        { paramName: 'maxPointScale', displayName: 'Max Point Scale', type: 'float', defaultValue: 5 },

    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                fieldSize,
                blitMode,
                movePosition,
                moveHeading,
                minColor,
                maxColor,
                minSize,
                maxSize,
                minSpeed,
                maxSpeed,
                minPointSpeed,
                maxPointSpeed,
                minPointScale,
                maxPointScale,
            } = { ...config }

            const dstImage = renderer.canvasBuffer.data

            const dx = Math.sin(moveHeading) * movePosition
            const dy = -Math.cos(moveHeading) * movePosition
            const minColorMult = [minColor[0]*255, minColor[1]*255, minColor[2]*255]
            const maxColorMult = [maxColor[0]*255, maxColor[1]*255, maxColor[2]*255]

            const blitters = {
                set: (x, y, sizeStart, sizeEnd, r, g, b) => {
                    for (let py = y-sizeStart; py < y+sizeEnd; ++py) {
                        if (py >=0 && py < 480) {
                            const x1 = x-sizeStart
                            let dstPtr = (x1 + py*640) *4
                            for (let px = x1; px < x+sizeEnd; ++px) {
                                if (px >=0 && px < 640) {
                                    dstImage[dstPtr++] = r
                                    dstImage[dstPtr++] = g
                                    dstImage[dstPtr++] = b
                                    dstPtr++
                                } else {
                                    dstPtr += 4
                                }
                            }
                        }
                    }                
                },
                add: (x, y, sizeStart, sizeEnd, r, g, b) => {
                    for (let py = y-sizeStart; py < y+sizeEnd; ++py) {
                        if (py >=0 && py < 480) {
                            const x1 = x-sizeStart
                            let dstPtr = (x1 + py*640) *4
                            for (let px = x1; px < x+sizeEnd; ++px) {
                                if (px >=0 && px < 640) {
                                    dstImage[dstPtr++] += r
                                    dstImage[dstPtr++] += g
                                    dstImage[dstPtr++] += b
                                    dstPtr++
                                } else {
                                    dstPtr += 4
                                }
                            }
                        }
                    }                
                },
                sub: (x, y, sizeStart, sizeEnd, r, g, b) => {
                for (let py = y-sizeStart; py < y+sizeEnd; ++py) {
                        if (py >=0 && py < 480) {
                            const x1 = x-sizeStart
                            let dstPtr = (x1 + py*640) *4
                            for (let px = x1; px < x+sizeEnd; ++px) {
                                if (px >=0 && px < 640) {
                                    dstImage[dstPtr++] -= r
                                    dstImage[dstPtr++] -= g
                                    dstImage[dstPtr++] -= b
                                    dstPtr++
                                } else {
                                    dstPtr += 4
                                }
                            }
                        }
                    }                
                }
            }
            const blitter = blitters[blitMode]

            self.motes.forEach(mote => {
                const a = mote[2]
                const size = lerp(minSize,maxSize,a)
                const sizeStart = Math.floor(size/2)
                const sizeEnd = Math.ceil(size/2)
                if (size > 0) {
                    const speed = Math.floor(lerp(minSpeed,maxSpeed,a))
                    const baseX = mote[0]*fieldSize + dx*speed
                    const baseY = mote[1]*fieldSize + dy*speed

                    const pointScale = lerp(minPointScale, maxPointScale, a)
                    const pointSpeed = lerp(minPointSpeed, maxPointSpeed, a)
                    const points = mote[3]
                    const pa = frameTime*pointSpeed
                    const pt = pa%1
                    const pi0 = Math.floor(pa)%points.length
                    const pi1 = (pi0+1)%points.length
                    const pi2 = (pi0+2)%points.length
                    const pi3 = (pi0+3)%points.length
                    const p = catmullRomSpline2(pt, points[pi0], points[pi1], points[pi2], points[pi3])
                    const pX = p[0]*pointScale
                    const pY = p[1]*pointScale

                    const x = Math.floor(((baseX + pX) + 100000)%fieldSize + (640 - fieldSize)/2)
                    const y = Math.floor(((baseY + pY) + 100000)%fieldSize + (480 - fieldSize)/2)
                    const r = lerp(minColorMult[0], maxColorMult[0], a)
                    const g = lerp(minColorMult[1], maxColorMult[1], a)
                    const b = lerp(minColorMult[2], maxColorMult[2], a)

                    blitter(x, y, sizeStart, sizeEnd, r, g, b)
                }
            })
        }
    }
}
