'use strict'

entityRegistry['module']['distortFinal'] = {
    init: (staticConfig) => {
        const {
        } = { ...staticConfig }

        const octaveData = [
            [0.030, 4.5,12.34, 0.5],
            [0.001, 2.22,1.99, 0.3],
            [0.123, 5.7,11.17, 0.2],
         ]
         const noiseRng = new Math.seedrandom('noise')
         const noiseData = new Float32Array([...Array(1000).keys()].map(x => noiseRng() * 2 - 1))
         return {
             octaveData,
             noiseData
         }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'strength', displayName: 'Strength', type: 'float', defaultValue: 1},
        { paramName: 'magnetDistance', displayName: 'Magnet Distance', type: 'float', defaultValue: 0},
        { paramName: 'distortDistance', displayName: 'Distort Distance', type: 'float', defaultValue: 20},
        { paramName: 'distortTime', displayName: 'Distort Time', type: 'float', defaultValue: 0},
        { paramName: 'brightness', displayName: 'Brightness', type: 'float', defaultValue: 0.5},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                strength,
                magnetDistance,
                distortDistance,
                distortTime,
                brightness,
            } = { ...config }

            /*
            const pixels = renderer.canvasBuffer.data
            let writeIndex = 0
            for (let readIndex = 0; readIndex < 640 * 480; ++readIndex) {
                pixels[writeIndex++] = 0
                writeIndex++
                writeIndex++
                writeIndex++
            }
            */

            {
                if (strength > 0.1) {
                    const magnetTime = frameTime * 1.57
                    const magnetTimeAlpha = magnetTime % 1
                    const magnetStrengthA = self.noiseData[Math.floor(frameTime) % self.noiseData.length]
                    const magnetStrengthB = self.noiseData[(Math.floor(frameTime) + 1) % self.noiseData.length]
                    const magnetStrength = (magnetStrengthA + (magnetStrengthB - magnetStrengthA) * magnetTimeAlpha) * 0.5 + 0.5
            
                    const dstBuffer = new Uint8Array(640*4)
                    for (let y = 0; y < 480; ++y) {
                        const srcBuffer = renderer.canvasBuffer.data
                        let writeIndex = 0

                        const lineBrightness = 1 +
                                Math.sin(-distortTime*1.21 + y*0.012)*brightness*0.75 + 
                                Math.sin(+distortTime*1.53 + y*0.003)*brightness*0.25
            
                        const readLine = 640 * y * 4
                        let distortValue = 0
                        for (let i = 0; i < self.octaveData.length; ++i) {
                            const octave = self.octaveData[i]
                            distortValue += self.noiseData[Math.floor(y*octave[0] + (frameTime+octave[1])*octave[2]) % self.noiseData.length] * octave[3]
                        }
                        distortValue *= distortDistance
                        distortValue += Math.pow(1-(y/480), magnetStrength * 10 + 2) * magnetDistance * magnetStrength
                        distortValue *= strength
                        distortValue = Math.floor(distortValue)
                        if (distortValue > 0) {
                            let x = 0
                            const valueR = Math.min(255, srcBuffer[readLine+0] * lineBrightness)
                            const valueG = Math.min(255, srcBuffer[readLine+1] * lineBrightness)
                            const valueB = Math.min(255, srcBuffer[readLine+2] * lineBrightness)
                            for (; x < distortValue; ++x) {
//                                dstBuffer[writeIndex++] = value
                                dstBuffer[writeIndex++] = valueR
                                dstBuffer[writeIndex++] = valueG
                                dstBuffer[writeIndex++] = valueB
                            }
                            let readIndex = 0
                            for (; x < 640; ++x) {
                            //     dstBuffer[writeIndex++] = srcBuffer[readLine + readIndex++] * lineBrightness
                                dstBuffer[writeIndex++] = Math.min(255, srcBuffer[readLine+readIndex*4+0] * lineBrightness)
                                dstBuffer[writeIndex++] = Math.min(255, srcBuffer[readLine+readIndex*4+1] * lineBrightness)
                                dstBuffer[writeIndex++] = Math.min(255, srcBuffer[readLine+readIndex*4+2] * lineBrightness)
                                readIndex++
                            }
                        } else {
                            let readIndex = -distortValue
                            let x = 0
                            let valueR, valueG, valueB
                            for (; x < 640 + distortValue; ++x) {
                            //     value = srcBuffer[readLine + readIndex++] * lineBrightness
                            //     dstBuffer[writeIndex++] = value
                                valueR = Math.min(255, srcBuffer[readLine+readIndex*4+0] * lineBrightness)
                                valueG = Math.min(255, srcBuffer[readLine+readIndex*4+1] * lineBrightness)
                                valueB = Math.min(255, srcBuffer[readLine+readIndex*4+2] * lineBrightness)
                                readIndex++
                                dstBuffer[writeIndex++] = valueR
                                dstBuffer[writeIndex++] = valueG
                                dstBuffer[writeIndex++] = valueB
                            }
                            for (; x < 640; ++x) {
                            //     dstBuffer[writeIndex++] = value
                                dstBuffer[writeIndex++] = valueR
                                dstBuffer[writeIndex++] = valueG
                                dstBuffer[writeIndex++] = valueB
                            }
                        }

                        let readIndex = 0
                        for (let i = 0; i < 640*4; i+=4) {
                            srcBuffer[640*y*4+i+0] = dstBuffer[readIndex++]
                            srcBuffer[640*y*4+i+1] = dstBuffer[readIndex++]
                            srcBuffer[640*y*4+i+2] = dstBuffer[readIndex++]
                        }
                    }
                }
            }
        }
    }
}
