'use strict'

entityRegistry['module']['depthToBrightness'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'enableDepth', displayName: 'Enable Depth', type: 'boolean', defaultValue: true},
        { paramName: 'mode', displayName: 'Mode', type: 'string', defaultValue: 'mult', uiOptions: { options: [{text:'Set', value:'set'}, {text:'Multiply', value:'mult'}] }},
        { paramName: 'minDepth', displayName: 'Min Depth', type: 'float', defaultValue: 0, uiOptions: { scrollScales: [0.1, 1, 10] }},
        { paramName: 'maxDepth', displayName: 'Max Depth', type: 'float', defaultValue: 100, uiOptions: { scrollScales: [0.1, 1, 10] }},
        { paramName: 'minBrightness', displayName: 'Min Brightness', type: 'float', defaultValue: 1, uiOptions: { min: 0, scrollScales: [0.01, 0.1, 1] }},
        { paramName: 'maxBrightness', displayName: 'Max Brightness', type: 'float', defaultValue: 0, uiOptions: { min: 0, scrollScales: [0.01, 0.1, 1] }},
        { paramName: 'enableAO', displayName: 'Enable AO', type: 'boolean', defaultValue: true},
        { paramName: 'xminAODepth', displayName: 'Min Depth', type: 'float', defaultValue: 0.01, uiOptions: { min: 0, scrollScales: [0.01, 0.1, 1] }},
        { paramName: 'xmaxAODepth', displayName: 'Max Depth', type: 'float', defaultValue: 0.1, uiOptions: { min: 0, scrollScales: [0.01, 0.1, 1] }},
        { paramName: 'strengthAO', displayName: 'Strength', type: 'float', defaultValue: 0.6, uiOptions: { min: 0, scrollScales: [0.01, 0.1, 1] }},
        { paramName: 'enableDOF', displayName: 'Enable DOF', type: 'boolean', defaultValue: true},
        { paramName: 'dofBlurPasses', displayName: 'Blur Passes', type: 'int', defaultValue: 3, uiOptions: { min: 1, max: 10 }},
        { paramName: 'focalPoint', displayName: 'Focal Point', type: 'float', defaultValue: 10, uiOptions: { scrollScales: [0.01, 0.1, 1] }},
        { paramName: 'focalLength', displayName: 'Focal Length', type: 'float', defaultValue: 4, uiOptions: { min: 0, scrollScales: [0.01, 0.1, 1] }},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                mode,
                enableDepth,
                minDepth,
                maxDepth,
                minBrightness,
                maxBrightness,
                enableAO,
                xminAODepth,
                xmaxAODepth,
                strengthAO,
                enableDOF,
                dofBlurPasses,
                focalPoint,
                focalLength,
            } = { ...config }

            const rangeDepth = maxDepth - minDepth

            const depthBuffer = renderer.getCurrentBuffer('depth')
            const depthBufferData = depthBuffer.data
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')
            const brightnessBufferData = brightnessBuffer.data

            // Depth darken
            if (enableDepth) {
                if (mode === 'set') {
                    for (let i = 0; i < depthBuffer.pixelCount; ++i) {
                        let v = depthBufferData[i]
                        v = clamp((v - minDepth) / rangeDepth, 0, 1)
                        brightnessBufferData[i] = lerp(minBrightness, maxBrightness, v**2)
                    }
                } else if (mode === 'mult') {
                    for (let i = 0; i < depthBuffer.pixelCount; ++i) {
                        let v = depthBufferData[i]
                        v = clamp((v - minDepth) / rangeDepth, 0, 1)
                        brightnessBufferData[i] *= lerp(minBrightness, maxBrightness, v**2)
                    }
                }
            }

            // SSAO
            if (enableAO) {
                const minAODepth = -xminAODepth
                const maxAODepth = -xmaxAODepth
                for (let x = 0; x < depthBuffer.width; ++x) {
                    let index = x + 3 * depthBuffer.width
                    for (let y = 3; y < depthBuffer.height - 3; ++y) {
                        const dp3 = depthBufferData[index - 640 * 3]
                        const dp2 = depthBufferData[index - 640 * 2]
                        const dp1 = depthBufferData[index - 640 * 1]
                        const d0 = depthBufferData[index]
                        const dm1 = depthBufferData[index + 640 * 1]
                        const dm2 = depthBufferData[index + 640 * 2]
                        const dm3 = depthBufferData[index + 640 * 3]
    
                        let v = 1
                        let d
    
                        d = (dm3 - d0) - (d0 - dp3); if (d > maxAODepth && d < minAODepth) v *= 1+(maxAODepth-d)*strengthAO/3
                        d = (dm2 - d0) - (d0 - dp2); if (d > maxAODepth && d < minAODepth) v *= 1+(maxAODepth-d)*strengthAO/2
                        d = (dm1 - d0) - (d0 - dp1); if (d > maxAODepth && d < minAODepth) v *= 1+(maxAODepth-d)*strengthAO
    
                        if (v !== 1) brightnessBufferData[index] *= v
    
                        index += 640
                    }
                }
                for (let y = 0; y < depthBuffer.height; ++y) {
                    let index = y * depthBuffer.width + 3
                    for (let x = 3; x < depthBuffer.width - 3; ++x) {
                        const dp3 = depthBufferData[index - 3]
                        const dp2 = depthBufferData[index - 2]
                        const dp1 = depthBufferData[index - 1]
                        const d0 = depthBufferData[index]
                        const dm1 = depthBufferData[index + 1]
                        const dm2 = depthBufferData[index + 2]
                        const dm3 = depthBufferData[index + 3]
    
                        let v = 1
                        let d
    
                        d = (dm3 - d0) - (d0 - dp3); if (d > maxAODepth && d < minAODepth) v *= 1+(maxAODepth-d)*strengthAO/3
                        d = (dm2 - d0) - (d0 - dp2); if (d > maxAODepth && d < minAODepth) v *= 1+(maxAODepth-d)*strengthAO/2
                        d = (dm1 - d0) - (d0 - dp1); if (d > maxAODepth && d < minAODepth) v *= 1+(maxAODepth-d)*strengthAO
    
                        if (v !== 1) brightnessBufferData[index] *= v
    
                        index += 1
                    }
                }
            }

            // DOF
            if (enableDOF) {
                let dst2Id = renderer.lockBuffer('brightness')
                let dst1Id = renderer.lockBuffer('brightness')
                let dst1 = renderer.getBufferFromId('brightness', dst1Id).data
                let dst2 = renderer.getBufferFromId('brightness', dst2Id).data
                let writeIndex = 0
                for (let y = 0; y < 480; y+=2) {
                    for (let x = 0; x < 640; x+=2) {
                        const v = (brightnessBufferData[(y+0)*640 + x+0] +
                                   brightnessBufferData[(y+0)*640 + x+0] +
                                   brightnessBufferData[(y+1)*640 + x+1] +
                                   brightnessBufferData[(y+1)*640 + x+1]) / 4
                        dst1[writeIndex++] = v
                    }
                }
                for (let blurPass = 0; blurPass < dofBlurPasses; ++blurPass) {
                    {
                        let index = 0
                        for (let x = 0; x < 320; ++x) dst2[index] = dst1[index++]
                        for (let y = 1; y < 240-1; ++y) {
                            dst2[index] = dst1[index++]
                            for (let x = 1; x < 320-1; ++x) {
                                const v = (dst1[index-1] +
                                        dst1[index+1] +
                                        dst1[index] +
                                        dst1[index-320] +
                                        dst1[index+320]) / 5
                                dst2[index++] = v
                            }
                            dst2[index] = dst1[index++]
                        }
                        for (let x = 0; x < 320; ++x) dst2[index] = dst1[index++]
                    }
                    {
                        let index = 0
                        for (let x = 0; x < 320; ++x) dst1[index] = dst2[index++]
                        for (let y = 1; y < 240-1; ++y) {
                            dst1[index] = dst2[index++]
                            for (let x = 1; x < 320-1; ++x) {
                                const v = (dst2[index-1] +
                                        dst2[index+1] +
                                        dst2[index] +
                                        dst2[index-320] +
                                        dst2[index+320]) / 5
                                dst1[index++] = v
                            }
                            dst1[index] = dst2[index++]
                        }
                        for (let x = 0; x < 320; ++x) dst1[index] = dst2[index++]
                    }
                }
                const iFocalLength = 1/focalLength
                const src = dst1
                const dst = brightnessBufferData
                let index = 0
                for (let y = 0; y < 480; ++y) {
                    for (let x = 0; x < 640; ++x) {
                        const depth = clamp(Math.abs((depthBufferData[index]-focalPoint) * iFocalLength), 0, 1)
                        dst[index] = Math.max(lerp(dst[index], src[(y>>1)*320+(x>>1)], depth**2), 0)
                        index++
                    }
                }
                renderer.unlockBuffer('brightness', dst2Id)
                renderer.unlockBuffer('brightness', dst1Id)
            }
        }
    }
}
