'use strict'

entityRegistry['module']['balls'] = {
    init: (staticConfig) => {
        const {
            seed,
            numBalls
        } = { ...staticConfig }
        const rng = new Math.seedrandom(seed)
        const balls = []
        for (let i = 0; i < numBalls; ++i) {
            const dir = randomNormal(rng)
            const distance = rng()
            const size = rng()
            const color = [Math.floor(rng()*4)/4,0.3,0.2]
            const cycle = rng()
            balls.push([dir, distance, size, color, cycle])
        }
        return {
            balls
        }
    },
    staticConfig: [
        { paramName: 'seed', displayName: 'Seed', type: 'string', defaultValue: 'seed', triggerInit: true },
        { paramName: 'numBalls', displayName: 'Balls', type: 'int', defaultValue: 100, triggerInit: true },
    ],
    dynamicConfig: [
        { paramName: 'model', displayName: 'Model', type: 'model', defaultValue: '' },
        { paramName: 'minSphereSize', displayName: 'Min Sphere Size', type: 'float', defaultValue: 10 },
        { paramName: 'maxSphereSize', displayName: 'Max Sphere Size', type: 'float', defaultValue: 10 },
        { paramName: 'minBallSize', displayName: 'Min Ball Size', type: 'float', defaultValue: 1 },
        { paramName: 'maxBallSize', displayName: 'Max Ball Size', type: 'float', defaultValue: 1 },
        { paramName: 'animation', displayName: 'Animation', type: 'float', defaultValue: 0 },
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                model,
                minSphereSize,
                maxSphereSize,
                minBallSize,
                maxBallSize,
                animation,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            self.balls.forEach(([dir, distance, size, color, cycle]) => {
                const phase = Math.pow(Math.sin((animation + cycle) * Math.PI*2), 2)
                const paletteId = renderer.getPaletteId(color, [lerp(0,color[0],phase), lerp(0,color[1],phase), lerp(0,color[2],phase)])

                const position = m4.multiplyVector(dir, lerp(minSphereSize, maxSphereSize, distance*phase))
                const translationMat = m4.translation(position[0], position[1], position[2])
                const scale = lerp(minBallSize, maxBallSize, size*phase)
                const scaleMat = m4.scaling(scale, scale, scale)
    
                const worldMat = m4.multiply(translationMat, scaleMat)
                renderer.drawModel(model, worldMat, colorBuffer, depthBuffer, brightnessBuffer, paletteId)
            })
        }
    }
}
