; STARP.ASM - PRINT CHRISTMAS STAR ON THE CONSOLE
; VINTAGE COMPUTING CHRISTMAS CHALLENGE 2022 (VC3 2022)
; WRITTEN BY SERGEY KISELEV <SKISELEV@GMAIL.COM>
;
; RUNS ON CP/M SYSTEMS WITH INTEL 8080, ZILOG Z80
;   AND COMPATIBLE PROCESSORS
;
; BUILDING AND RUNNIG STEPS:
; A>ASM STARP
; A>LOAD STARP
; A>STARP

BDOS	EQU	5
WCHAR	EQU	2
SIZE	EQU	17

	ORG	0100H
	MVI	H,SIZE		; ROW COUNTER

LOOPY:
	MVI	L,SIZE		; COLUMN COUNTER

LOOPX:
; CALCULATE Y = ABS(COLUMN-SIZE/2+1)
	MOV	A,H		; A = ROW
	SUI	SIZE/2+1	; A -= SIZE/2+1
	JP	ABSY		; JUMP IF A IS POSITIVE
	CMA			; A = XOR A
	INR	A		; A =-A
ABSY:	MOV	C,A		; C = Y

; CALCULATE X = ABS(COLUMN-SIZE/2+1)
	MOV	A,L		; A = COLUMN
	SUI	SIZE/2+1	; A -=SIZE/2+1
	JP	ABSX		; JUMP IF A IS POSITIVE
	CMA			; A = XOR A
	INR	A		; A =-A
ABSX:	MOV	B,A		; B = X

; D = SIZE/4+1
; E = ' ' - PRINT SPACE BY DEFAULT
	LXI	D,(SIZE/4+1) SHL 8 OR ' '

; IF (X>4 & Y>4) PRINT " "
	CMP	D		; X > 4?
	JM	CMPXY		; JUMP IF X < 4
	MOV	A,C		; A = Y
	CMP	D		; Y > 4?
	JP	PRINT		; JUMP IF Y > 4

; ELSE IF (X-Y>4) PRINT " "
CMPXY:	MOV	A,B		; A = X
	SUB	C		; A = X-Y
	SUB	D		; A = Y-X-4
	JP	PRINT		; JUMP IF X-Y-4 > 0

; ELSE IF (Y-X>4) PRINT " "
	MOV	A,C		; A = Y
	SUB	B		; A = Y-X
	SUB	D		; A = Y-X-4
	JP	PRINT		; JUMP IF Y-X-4 > 0

; ELSE PRINT "*"	
	MVI	E,'*'		; PRINT AN ASTERISK

PRINT:	CALL	PUTC		; OUTPUT TO THE CONSOLE
	DCR	L		; DECREMENT THE COLUMN COUNTER
	JNZ	LOOPX		; JUMP IF NOT AT THE LAST COLUMN
	MVI	E,0DH		; CARRIAGE RETURN
	CALL	PUTC		; OUTPUT TO THE CONSOLE
	MVI	E,0AH		; LINE FEED
	CALL	PUTC		; OUTPUT TO THE CONSOLE
	DCR	H		; DECREMENT THE ROW COUNTER
	JNZ	LOOPY		; JUMP IF NOT AT THE LAST ROW
	RET			; RETURN TO CP/M

; PUTC - PRINT THE CHARACTER FROM REGISTER E TO THE CONSOLE
PUTC:	PUSH	H
	MVI	C,WCHAR
	CALL	BDOS		; OUTPUT TO THE CONSOLE
	POP	H
	RET

	END
