//--- vc3-2022 challenge by Rensoupp (Doesn't use any OS/Basic code or data)

//The system must be set to 600/800XL PAL or NSTC with at least 64KB of RAM. This is important because the screen address is hardcoded in my entry. It is possible to grab the screen address but that would require extra setup code which wouldn't be fair compared to the C64 where I suppose the screen address is always the same since there's only 1 model.

//For firmwares:

//Either 1. Operating System: Altirra OS (tested with 3.34). BASIC: Atari Basic rev.C or Altirra Basic (tested with 1.58). Basic MUST BE enabled (This is important because when returning from my entry, Altirra OS boots back into its own welcome screen while Basic leaves the star on screen)

//Or 2. Operating System: Atari XL/XE OS ver.2. Basic: Same as above (Atari or Altirra Basic). Basic does NOT need to be enabled because when returning from my entry, the OS goes into Basic, leaving the screen intact.

.file [name="xmasstar.xex", type="bin", segments="XexHeader,Code"] 

.const BaseLine = 5 // buggy, can't be placed anywhere on screen (0 or 5 work) because some parts would start on different pages while I'm forcing the Hi screen start address byte to always be the same.
.const Offset = 11

.const SCREENBASE = $9c40
.const SCRADDR1 = SCREENBASE+40*(4+BaseLine)+4+Offset
.const SCRADDR2 = SCREENBASE+40*(4+BaseLine)+0+Offset
.const SCRADDR3 = SCREENBASE+40*BaseLine+4+Offset
.const SCRADDR4 = SCREENBASE+40*BaseLine+4+8+Offset

.segment ZeroPage []

*=$0 "ZP" virtual 

.zp 
{
    .namespace ZP
    {
        Screen:     .word 0 
        AddLine:    .byte 0
        StarCount:  .byte 0
    }
}

.const SegmentOrg       =   $4000

.segment XexHeader []
*= SegmentOrg-6 "XexHeader"
.byte $FF,$FF 
.word XexStart
.word XexEnd-1

;//---------------------------------------------------------------------------------------------

.segment Code []
*= SegmentOrg "Code"
XexStart: 
{ 
    ldx #41
    //--- right triangle 1
    lda #<SCRADDR2
    ldy #13
    jsr Tri1

    //--- left triangle 1
    lda #<SCRADDR1
    ldy #13
    jsr Tri2

    //--- reverse top bottom
    lda #13
    sta SM_SetCMP+1
    lda #$c8 ;// iny
    sta SM_SetIncDec

    //--- left triangle 2
    lda #<SCRADDR3
    jsr Tri1

    //--- right triangle 2
//    lda #<SCRADDR4 // not needed because ScreenLO ends up at the right spot!
//    jsr tri2     //drop through, rts will give control back to OS
//Done:
//    bcs Done

Tri2:
    dex
Tri1:
    sta ZP.Screen
    lda #>SCRADDR1
    sta ZP.Screen+1

NextLine:    

SM_SetIncDec:
    dey
SM_SetCMP:
    cpy #$ff
    beq DonePass

    sty ZP.StarCount
    lda #10

NextStarLine:
    sta (ZP.Screen),y
    dey
    bpl NextStarLine

    ldy ZP.StarCount
//    clc
    txa 
    adc ZP.Screen
    sta ZP.Screen  
    bcc NoInc2
    inc ZP.Screen+1
NoInc2: 
    bne NextLine 

DonePass:    
    ldy #$ff
    rts


}
XexEnd:
