	.z80
	.area _CODE
_start::
	;; bc is the start address and c must be 0x20
	;; h is used 3 times in the code
	;; l is y, counting down from 22
	ld	hl, #(10<<8)|22
loop_y:
	;; b is x, counting down from 32
	ld	b, c
loop_x:
	;; Calculate abs(x-10) and shift the carry flag from the
	;; comparison into e
	ld	a, b
	sub	h
	call	abs_a_and_compare

	;; Store abs(x-10) in d
	ld	d, a

	;; Calculate abs(y-10) and shift the carry flag from the
	;; comparison into e
	ld	a, l
	sub	h
	call	abs_a_and_compare

	;; Calculate abs(abs(y-10)-abs(x-10)) and shift the carry
	;; flag from the comparison into e
	sub	d
	call	abs_a_and_compare

	;; The 3 upper bits of e now have these values:
	;; - 7 abs(abs(y-10) - abs(x-10)) < 5
	;; - 6 abs(y-10) < 5
	;; - 5 abs(x-10) < 5
	;; If bit 7 is set and either bit 6 or 5 is set, we are inside
	;; the star.

	;; This sets the carry flag if e is 10100000 or larger, which
	;; means that we are inside the star. 
	ld	a, #0b10100000-1
	cp	e

	;; Set a to 0xff is the carry is set and 0x00 if not
	sbc	a

	;; Set a to * (0x2a) if it is 0xff or space (0x20) if it is
	;; 0x00
	and	h
	or	c

	;; Print the character
	rst	0x10

	;; Loop over x
	djnz	loop_x

	;; ...and over y
	dec	l
	jr	nz, loop_y

	;; Return to BASIC, reusing the ret instruction of the
	;; function

;;; This function set a to abs(a) and assumes that the carry flag
;;; is set if a is negative. It also shifts 1 or 0 into the top bit of
;;; e if abs(a) is less than 5 or not.
abs_a_and_compare:
	jr	nc, is_positive
	neg
is_positive:
	cp	#5
	rr	e
	ret
