#include <arch/zx.h>

void printCharAt(uint8_t x, uint8_t y, uint8_t c) {
   uint8_t *p = zx_cxy2saddr(x, y);
   uint8_t *dat = (uint8_t *)15360 + (c * 8);
   for (uint8_t i = 0; i < 8; ++i) {
      *p = *dat++;      
      p += 256;
   }
}

uint8_t checkPrintSpace(uint8_t x, uint8_t y) {
    if ((y > 3 && y < 12) &&
        ((y <= 8 && ((x < (y - 4)) || (x > (20 - y)))) ||
        ((y > 8 && ((x < (12 - y)) || (x > (y + 4)))))
        ) ||
        ((y < 4 || y > 12) && (
            (x < 4 || x > 12) ||
            (x > (y + 4) && x < (12 - y)) ||
            (x < (y - 4) && x > (20 - y))
        )
        ))
        return 1;
    else
        return 0;
}

int main() {
    zx_cls(PAPER_WHITE);
    for (uint8_t y=0; y<17; ++y) {
        for (uint8_t x=0; x<17; ++x) {
            printCharAt(x, y, checkPrintSpace(x, y)?' ':'*');
        }
    }    
    return 0;
} 