/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import processing.core.PCanvas;

public class PImage {
    public Image image;
    public final int width;
    public final int height;
    public final boolean mutable;

    protected PImage(int n, int n2, boolean bl) {
        this.width = n;
        this.height = n2;
        this.mutable = bl;
    }

    public PImage(int n, int n2) {
        this.image = Image.createImage((int)n, (int)n2);
        this.width = n;
        this.height = n2;
        this.mutable = true;
    }

    public PImage(int n, int n2, int n3) {
        this(n, n2);
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(n3);
        graphics.fillRect(0, 0, n, n2);
    }

    public PImage(Image image) {
        this.image = image;
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.mutable = false;
    }

    public PImage(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public PImage(byte[] byArray, int n, int n2) {
        try {
            this.image = Image.createImage((byte[])byArray, (int)n, (int)n2);
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
            this.mutable = false;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (PCanvas.imageMode == 3) {
            n3 -= n;
            n4 -= n2;
        }
        Image image = Image.createImage((int)n3, (int)n4);
        Graphics graphics = image.getGraphics();
        graphics.drawImage(this.image, -n, -n2, 20);
        this.copy(image, 0, 0, n3, n4, n5, n6, n7, n8);
    }

    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.copy(pImage.image, n, n2, n3, n4, n5, n6, n7, n8);
    }

    private void copy(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (!this.mutable) {
            throw new RuntimeException("this image cannot be overwritten");
        }
        if (PCanvas.imageMode == 3) {
            n3 -= n;
            n4 -= n2;
            n7 -= n5;
            n8 -= n6;
        }
        Graphics graphics = this.image.getGraphics();
        if (n7 == n3 && n8 == n4) {
            graphics.setClip(n5, n6, n7, n8);
            graphics.drawImage(image, n5 - n, n6 - n2, 20);
        } else if (n7 == n3) {
            int n9 = n6 - n2;
            for (int i = 0; i < n8; ++i) {
                graphics.setClip(n5, n6 + i, n7, 1);
                graphics.drawImage(image, n5 - n, n9, 20);
                n9 = n6 - n2 - i * n4 / n8 + i;
            }
        } else if (n8 == n4) {
            int n10 = n5 - n;
            for (int i = 0; i < n7; ++i) {
                graphics.setClip(n5 + i, n6, 1, n8);
                graphics.drawImage(image, n10, n6 - n2, 20);
                n10 = n5 - n - i * n3 / n7 + i;
            }
        } else {
            int n11 = n6 - n2;
            for (int i = 0; i < n8; ++i) {
                int n12 = n5 - n;
                for (int j = 0; j < n7; ++j) {
                    graphics.setClip(n5 + j, n6 + i, 1, 1);
                    graphics.drawImage(image, n12, n11, 20);
                    n12 = n5 - n - j * n3 / n7 + j;
                }
                n11 = n6 - n2 - i * n4 / n8 + i;
            }
        }
    }

    protected void draw(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.image, n, n2, 20);
    }
}

