/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PImage;
import processing.core.PMIDlet;

public class Symbows_Solitaire
extends PMIDlet {
    final int D_LEFT;
    final int D_RIGHT;
    final int D_UP;
    final int D_DOWN;
    final int D_SELECT;
    final int anim;
    int backgroundColor;
    int cursorColor;
    int selectedColor;
    Klondike klondike;

    public void setup() {
        this.softkey("Reset");
        this.backgroundColor = this.color(51, 153, 0);
        this.cursorColor = this.color(204, 153, 0, 79);
        this.selectedColor = this.color(255, 153, 51, 255);
        this.klondike = new Klondike();
    }

    public void draw() {
        this.background(this.backgroundColor);
        this.klondike.draw();
    }

    public void keyPressed() {
        if (this.keyCode == 8) {
            this.klondike.selectKey();
        } else if (this.keyCode == 2 || this.keyCode == 5 || this.keyCode == 1 || this.keyCode == 6) {
            int n = -1;
            if (this.keyCode == 2) {
                n = 0;
            } else if (this.keyCode == 5) {
                n = 1;
            } else if (this.keyCode == 1) {
                n = 2;
            } else if (this.keyCode == 6) {
                n = 3;
            }
            this.klondike.directionKey(n);
        }
    }

    public void softkeyPressed(String string) {
        if (string.equals("Reset")) {
            this.klondike = new Klondike();
            this.redraw();
        }
    }

    public Symbows_Solitaire() {
        this.D_LEFT = 2;
        this.D_RIGHT = 5;
        this.D_UP = 1;
        this.D_DOWN = 6;
        this.D_SELECT = 8;
        this.anim = 4;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Klondike
    extends CardGame {
        public void draw() {
            int n = 0;
            while (n < Symbows_Solitaire.this.length(((CardGame)this).piles)) {
                ((CardGame)this).piles[n].draw();
                ++n;
            }
            ((CardGame)this).hand.draw();
            ((CardGame)this).cursor.draw();
        }

        public void directionKey(int n) {
            int[][] nArrayArray = new int[4][];
            int[] nArray = new int[13];
            nArray[0] = 12;
            nArray[2] = 8;
            nArray[3] = 2;
            nArray[4] = 3;
            nArray[5] = 4;
            nArray[6] = 5;
            nArray[7] = 6;
            nArray[8] = 7;
            nArray[9] = 1;
            nArray[10] = 9;
            nArray[11] = 10;
            nArray[12] = 11;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[13];
            nArray2[0] = 1;
            nArray2[1] = 9;
            nArray2[2] = 3;
            nArray2[3] = 4;
            nArray2[4] = 5;
            nArray2[5] = 6;
            nArray2[6] = 7;
            nArray2[7] = 8;
            nArray2[8] = 2;
            nArray2[9] = 10;
            nArray2[10] = 11;
            nArray2[11] = 12;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[13];
            nArray3[0] = 2;
            nArray3[1] = 3;
            nArray3[3] = 1;
            nArray3[4] = 1;
            nArray3[5] = 9;
            nArray3[6] = 10;
            nArray3[7] = 11;
            nArray3[8] = 12;
            nArray3[9] = 5;
            nArray3[10] = 6;
            nArray3[11] = 7;
            nArray3[12] = 8;
            nArrayArray[2] = nArray3;
            int[] nArray4 = new int[13];
            nArray4[0] = 2;
            nArray4[1] = 3;
            nArray4[3] = 1;
            nArray4[4] = 1;
            nArray4[5] = 9;
            nArray4[6] = 10;
            nArray4[7] = 11;
            nArray4[8] = 12;
            nArray4[9] = 5;
            nArray4[10] = 6;
            nArray4[11] = 7;
            nArray4[12] = 8;
            nArrayArray[3] = nArray4;
            int[][] nArrayArray2 = nArrayArray;
            boolean bl = true;
            if (this.cursorPile().type() == "Tableau" && (n == 2 || n == 3)) {
                if (((CardGame)this).hand.empty()) {
                    int n2 = ((Tableau)this.cursorPile()).getCursorDepth();
                    if (n == 2) {
                        if (((Tableau)this.cursorPile()).setCursorDepth(n2 + 1)) {
                            bl = false;
                        }
                    } else if (((Tableau)this.cursorPile()).setCursorDepth(n2 - 1)) {
                        bl = false;
                    }
                } else if (((CardGame)this).hand.size() > 1) {
                    bl = false;
                }
            }
            if (bl) {
                ((CardGame)this).cursorPileIndex = nArrayArray2[n][((CardGame)this).cursorPileIndex];
                if (!((CardGame)this).hand.empty() && ((CardGame)this).cursorPileIndex <= 1) {
                    ((CardGame)this).cursorPileIndex = 9;
                }
                if (this.cursorPile().type() == "Tableau") {
                    ((Tableau)this.cursorPile()).setCursorDepth(0);
                }
            }
            this.updateCursor();
        }

        public void selectKey() {
            if (((CardGame)this).hand.empty()) {
                Symbows_Solitaire.this.println("hand empty");
                if (this.cursorPile().type().equals("Stock")) {
                    Symbows_Solitaire.this.println("stock");
                    if (this.stock().empty()) {
                        Symbows_Solitaire.this.println("stock empty");
                        if (!this.waste().empty()) {
                            while (this.waste().size() > 0) {
                                this.stock().takeTopCardFromPile(this.waste());
                            }
                            this.waste().reset();
                            int n = 0;
                            while (n < 3) {
                                this.waste().takeTopCardFromPile(this.stock());
                                ++n;
                            }
                        }
                    } else {
                        Symbows_Solitaire.this.println("stock not empty");
                        this.waste().condense();
                        int n = 0;
                        while (n < 3) {
                            this.waste().takeTopCardFromPile(this.stock());
                            ++n;
                        }
                    }
                } else if (this.cursorPile().type().equals("Waste")) {
                    ((CardGame)this).hand.pickup(this.cursorPile());
                } else if (this.cursorPile().type().equals("Tableau") && !this.cursorPile().empty()) {
                    Card card = ((Tableau)this.cursorPile()).getCursorCard();
                    ((CardGame)this).hand.pickup(this.cursorPile(), card);
                }
                this.updateCursor();
            } else {
                Symbows_Solitaire.this.println("hand not empty");
                ((CardGame)this).hand.drop(this.cursorPile());
                if (this.cursorPile().type() == "Tableau") {
                    ((Tableau)this.cursorPile()).setCursorDepth(0);
                }
                this.updateCursor();
            }
        }

        public Deck deck() {
            return ((CardGame)this).decks[0];
        }

        public Stock stock() {
            return (Stock)((CardGame)this).piles[0];
        }

        public Waste waste() {
            return (Waste)((CardGame)this).piles[1];
        }

        public Tableau tableau(int n) {
            return (Tableau)((CardGame)this).piles[n + 2];
        }

        public Foundation foundation(int n) {
            return (Foundation)((CardGame)this).piles[n + 9];
        }

        private final Pile getPile(int n) {
            if (n >= 0 && n < Symbows_Solitaire.this.length(((CardGame)this).piles)) {
                return ((CardGame)this).piles[n];
            }
            return null;
        }

        private final Pile cursorPile() {
            return this.getPile(((CardGame)this).cursorPileIndex);
        }

        private final void updateCursor() {
            Pile pile = this.cursorPile();
            int n = pile.x() + 24;
            if (pile.type().equals("Waste")) {
                n += 12 * (((Waste)pile).fanout() - 1);
            }
            int n2 = this.cursorPile().y() + 3;
            if (pile.type().equals("Tableau") && !pile.empty()) {
                n2 += 8 * (pile.size() - ((Tableau)pile).getCursorDepth() - 1);
            }
            if (!((CardGame)this).hand.empty()) {
                n += 6;
                n2 += 8;
            }
            ((CardGame)this).hand.moveTo(n, n2);
            ((CardGame)this).cursor.moveTo(n, n2);
        }

        Klondike() {
            super.setState("init");
            ((CardGame)this).cursorPileIndex = 1;
            ((CardGame)this).decks = new Deck[1];
            ((CardGame)this).decks[0] = new Deck(this);
            this.deck().shuffle();
            ((CardGame)this).piles = new Pile[13];
            ((CardGame)this).piles[0] = new Stock(this);
            this.stock().moveTo(11, 7);
            ((CardGame)this).piles[1] = new Waste(this);
            this.waste().moveTo(55, 7);
            int n = 0;
            while (n < 7) {
                ((CardGame)this).piles[n + 2] = new Tableau(this, n);
                this.tableau(n).moveTo(11 + 44 * n, 57);
                ++n;
            }
            n = 0;
            while (n < 4) {
                ((CardGame)this).piles[n + 9] = new Foundation(this, this.deck().ranks[0], n);
                this.foundation(n).moveTo(143 + 44 * n, 7);
                ++n;
            }
            n = 0;
            while (n < 7) {
                int n2 = n;
                while (n2 < 7) {
                    this.tableau(n2).takeTopCardFromPile(this.deck());
                    ++n2;
                }
                ++n;
            }
            n = 0;
            while (n < 7) {
                this.tableau(n).topCard().turnFaceUp();
                ++n;
            }
            while (this.deck().cards() != null) {
                this.stock().takeTopCardFromPile(this.deck());
            }
            n = 0;
            while (n < 3) {
                this.waste().takeTopCardFromPile(this.stock());
                ++n;
            }
            ((CardGame)this).hand = new Hand(this);
            ((CardGame)this).cursor = new Cursor();
            this.updateCursor();
            super.setState("choose");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Waste
    extends Pile {
        int fanout;

        public boolean add(Card card) {
            if (card != null) {
                if (this.fanout < 3) {
                    card.turnFaceUp();
                    if (((Pile)this).parent.state().equals("undo")) {
                        card.moveTo(((Pile)this).pos.x + 12 * this.fanout, ((Pile)this).pos.y, 4);
                    } else {
                        card.moveTo(((Pile)this).pos.x + 12 * this.fanout, ((Pile)this).pos.y);
                    }
                    ++this.fanout;
                    return super.add(card, false);
                }
                int n = 0;
                while (n < this.fanout) {
                    ((Pile)this).cards[this.fanout - n - 1].moveTo(((Pile)this).pos.x, ((Pile)this).pos.y);
                    ++n;
                }
                this.fanout = 0;
                card.turnFaceUp();
                card.moveTo(((Pile)this).pos.x + 12 * this.fanout, ((Pile)this).pos.y);
                ++this.fanout;
                return super.add(card, false);
            }
            return false;
        }

        public boolean validate(Card card) {
            return false;
        }

        public boolean validate(Pile pile) {
            if (pile != null) {
                return pile.type().equals("Stock") || pile.type().equals("Hand") && pile.parent.state().equals("undo");
            }
            return false;
        }

        public Card removeCard(Card card) {
            if ((card = super.removeCard(card)) != null) {
                --this.fanout;
            }
            return card;
        }

        public boolean condense() {
            int n = 0;
            while (n < this.fanout) {
                ((Pile)this).cards[this.fanout - n - 1].moveTo(((Pile)this).pos.x, ((Pile)this).pos.y);
                ++n;
            }
            this.fanout = 0;
            return true;
        }

        public void draw() {
            if (!super.empty()) {
                if (Symbows_Solitaire.this.length(((Pile)this).cards) > this.fanout) {
                    ((Pile)this).cards[this.fanout].draw();
                }
                int n = 0;
                while (n < this.fanout) {
                    ((Pile)this).cards[this.fanout - n - 1].draw();
                    ++n;
                }
            }
        }

        public int fanout() {
            return this.fanout;
        }

        public void reset() {
            this.fanout = 0;
        }

        public String type() {
            return "Waste";
        }

        private final /* synthetic */ void this() {
            this.fanout = 0;
        }

        Waste(Klondike klondike) {
            super(klondike);
            this.this();
            this.name = "Waste";
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Tableau
    extends Pile {
        private int index;
        private int cursorDepth;

        public void draw() {
            if (!super.empty()) {
                int n = Symbows_Solitaire.this.length(((Pile)this).cards) - 1;
                while (n >= 0) {
                    ((Pile)this).cards[n].draw();
                    --n;
                }
            }
        }

        public boolean add(Card card) {
            if (card != null) {
                int n;
                if (((Pile)this).cards == null) {
                    ((Pile)this).cards = new Card[1];
                    ((Pile)this).cards[0] = card;
                } else {
                    Object[] objectArray = new Card[Symbows_Solitaire.this.length(((Pile)this).cards) + 1];
                    n = 1;
                    while (n < Symbows_Solitaire.this.length(objectArray)) {
                        objectArray[n] = ((Pile)this).cards[n - 1];
                        ++n;
                    }
                    ((Pile)this).cards = (Card[])objectArray;
                    ((Pile)this).cards[0] = card;
                }
                int n2 = ((Pile)this).pos.x;
                n = ((Pile)this).pos.y + 8 * (Symbows_Solitaire.this.length(((Pile)this).cards) - 1);
                int n3 = 25;
                if (((Pile)this).parent.state().equals("init")) {
                    n3 = 1;
                }
                card.moveTo(n2, n, n3);
                return true;
            }
            return false;
        }

        public boolean validate(Card card) {
            if (!super.empty()) {
                Card card2 = super.topCard();
                return !card.suitColour().equals(card2.suitColour()) && card2.rank().value() - card.rank().value() == 1;
            }
            return card.rank() == ((Klondike)((Pile)this).parent).deck().ranks[12];
        }

        public boolean validate(Pile pile) {
            if (pile != null) {
                return pile.type().equals("Deck") || pile.type().equals("Hand") && pile.parent.state().equals("undo");
            }
            return false;
        }

        public int getCursorDepth() {
            return this.cursorDepth;
        }

        public Card getCursorCard() {
            return ((Pile)this).cards[this.cursorDepth];
        }

        public boolean setCursorDepth(int n) {
            if (n >= 0 && n < this.cardsFacingUp()) {
                this.cursorDepth = n;
                return true;
            }
            return false;
        }

        private final int cardsFacingUp() {
            if (super.empty()) {
                return 0;
            }
            if (super.size() == 1) {
                return 1;
            }
            int n = super.size();
            int n2 = 0;
            while (n2 < super.size()) {
                if (((Pile)this).cards[n2].isFaceDown()) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            return n;
        }

        public String type() {
            return "Tableau";
        }

        private final /* synthetic */ void this() {
            this.cursorDepth = -1;
        }

        Tableau(Klondike klondike, int n) {
            super(klondike);
            this.this();
            this.index = n;
            this.name = "Tableau " + this.index;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Stock
    extends Pile {
        public boolean add(Card card) {
            if (card != null) {
                card.turnFaceDown();
                card.moveTo(((Pile)this).pos);
                return super.add(card, false);
            }
            return false;
        }

        public String type() {
            return "Stock";
        }

        public void draw() {
            if (!this.empty()) {
                this.topCard().draw();
            } else {
                this.drawEmpty();
            }
        }

        private final void drawEmpty() {
            Symbows_Solitaire.this.pushMatrix();
            Symbows_Solitaire.this.translate(((Pile)this).pos.x, ((Pile)this).pos.y);
            Symbows_Solitaire.this.image(((Klondike)((Pile)this).parent).deck().art(), 1, 142, 33, 45, 0, 0);
            Symbows_Solitaire.this.popMatrix();
        }

        Stock(Klondike klondike) {
            super(klondike);
            this.name = "Stock";
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Position {
        private int x;
        private int y;
        private int steps;
        private int fx;
        private int fy;
        private int tx;
        private int ty;
        private String state;

        public String toString() {
            return this.x + ", " + this.y;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public void moveTo(int n, int n2, int n3) {
            this.steps = Symbows_Solitaire.this.max(n3, 1);
            if (this.steps > 1) {
                this.state = "moving";
                this.tx = Symbows_Solitaire.this.itofp(n);
                this.ty = Symbows_Solitaire.this.itofp(n2);
            } else {
                this.state = "static";
                this.x = n;
                this.y = n2;
                this.fx = Symbows_Solitaire.this.itofp(n);
                this.fy = Symbows_Solitaire.this.itofp(n2);
                this.tx = this.fx;
                this.ty = this.fy;
            }
        }

        public void moveTo(int n, int n2) {
            this.moveTo(n, n2, 1);
        }

        public void moveTo(Position position, int n) {
            this.moveTo(position.x, position.y, n);
        }

        public void moveTo(Position position) {
            this.moveTo(position.x, position.y);
        }

        public void update() {
            int n;
            int n2;
            if (this.fx != this.tx) {
                n2 = Symbows_Solitaire.this.div(Symbows_Solitaire.this.abs(this.fx - this.tx), Symbows_Solitaire.this.itofp(this.steps));
                this.fx = this.fx > this.tx ? (this.fx -= n2) : (this.fx += n2);
            } else {
                n2 = -1;
            }
            if (this.fy != this.ty) {
                n = Symbows_Solitaire.this.div(Symbows_Solitaire.this.abs(this.fy - this.ty), Symbows_Solitaire.this.itofp(this.steps));
                this.fy = this.fy > this.ty ? (this.fy -= n) : (this.fy += n);
            } else {
                n = -1;
            }
            this.x = Symbows_Solitaire.this.fptoi(this.fx);
            this.y = Symbows_Solitaire.this.fptoi(this.fy);
            if (n2 <= 0 && n <= 0) {
                this.state = "static";
                this.x = Symbows_Solitaire.this.fptoi(this.tx);
                this.y = Symbows_Solitaire.this.fptoi(this.ty);
            }
        }

        private final /* synthetic */ void this() {
            this.steps = 1;
        }

        Position() {
            this(0, 0);
        }

        Position(int n, int n2) {
            this.this();
            this.state = "static";
            this.x = n;
            this.y = n2;
            this.fx = Symbows_Solitaire.this.itofp(n);
            this.fy = Symbows_Solitaire.this.itofp(n2);
            this.tx = this.fx;
            this.ty = this.fy;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Pile {
        private CardGame parent;
        private Card[] cards;
        private Position pos;
        String name;

        public void draw() {
            if (!this.empty()) {
                this.topCard().draw();
            } else {
                this.drawEmpty();
            }
        }

        private final void drawEmpty() {
            Symbows_Solitaire.this.pushMatrix();
            Symbows_Solitaire.this.translate(this.pos.x, this.pos.y);
            Symbows_Solitaire.this.image(((Klondike)this.parent).deck().art(), 1, 95, 33, 45, 0, 0);
            Symbows_Solitaire.this.popMatrix();
        }

        public Card[] cards() {
            return this.cards;
        }

        public Card card(int n) {
            if (!this.empty() && n >= 0 && n < Symbows_Solitaire.this.length(this.cards)) {
                return this.cards[n];
            }
            return null;
        }

        public Card anyCard() {
            if (!this.empty()) {
                return this.card(Symbows_Solitaire.this.random(Symbows_Solitaire.this.length(this.cards) - 1));
            }
            return null;
        }

        public Card bottomCard() {
            if (!this.empty()) {
                return this.card(Symbows_Solitaire.this.length(this.cards) - 1);
            }
            return null;
        }

        public Card topCard() {
            if (!this.empty()) {
                return this.card(0);
            }
            return null;
        }

        public boolean hasCard(Card card) {
            if (!this.empty()) {
                boolean bl = false;
                int n = 0;
                while (n < Symbows_Solitaire.this.length(this.cards)) {
                    if (this.cards[n].equals(card)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                return bl;
            }
            return false;
        }

        public int indexOfCard(Card card) {
            if (this.hasCard(card)) {
                int n = 0;
                while (n < Symbows_Solitaire.this.length(this.cards)) {
                    if (this.cards[n].equals(card)) break;
                    ++n;
                }
                return n;
            }
            return -1;
        }

        public Card removeCard(int n) {
            if (!this.empty() && n >= 0 && n < Symbows_Solitaire.this.length(this.cards)) {
                Card card = this.cards[n];
                if (Symbows_Solitaire.this.length(this.cards) > 1) {
                    Card[] cardArray = new Card[Symbows_Solitaire.this.length(this.cards) - 1];
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < Symbows_Solitaire.this.length(this.cards)) {
                        if (n3 != n) {
                            cardArray[n2] = this.cards[n3];
                            ++n2;
                        }
                        ++n3;
                    }
                    this.cards = cardArray;
                } else {
                    this.cards = null;
                }
                return card;
            }
            return null;
        }

        public Card removeCard(Card card) {
            return this.removeCard(this.indexOfCard(card));
        }

        public boolean add(Card card, boolean bl) {
            if (card != null) {
                if (this.cards == null) {
                    this.cards = new Card[1];
                    this.cards[0] = card;
                } else {
                    Object[] objectArray = new Card[Symbows_Solitaire.this.length(this.cards) + 1];
                    int n = 1;
                    while (n < Symbows_Solitaire.this.length(objectArray)) {
                        objectArray[n] = this.cards[n - 1];
                        ++n;
                    }
                    this.cards = objectArray;
                    this.cards[0] = card;
                }
                if (bl) {
                    if (this.parent.state().equals("init")) {
                        card.moveTo(this.pos.x, this.pos.y);
                    } else {
                        card.moveTo(this.pos.x, this.pos.y, 4);
                    }
                }
                return true;
            }
            return false;
        }

        public boolean add(Card card) {
            return this.add(card, true);
        }

        public void reverse() {
            Card[] cardArray = new Card[Symbows_Solitaire.this.length(this.cards)];
            int n = 0;
            while (n < Symbows_Solitaire.this.length(this.cards)) {
                cardArray[Symbows_Solitaire.this.length((Object[])this.cards) - n - 1] = this.cards[n];
                ++n;
            }
            this.cards = cardArray;
        }

        public void shuffle() {
            int n = Symbows_Solitaire.this.length(this.cards) - 1;
            while (n > 0) {
                int n2 = Symbows_Solitaire.this.random(n);
                Card card = this.cards[n];
                this.cards[n] = this.cards[n2];
                this.cards[n2] = card;
                --n;
            }
        }

        public boolean empty() {
            boolean bl = false;
            if (this.cards == null) {
                bl = true;
            }
            return bl;
        }

        public String name() {
            return this.name;
        }

        public int size() {
            if (!this.empty()) {
                return Symbows_Solitaire.this.length(this.cards);
            }
            return 0;
        }

        public String toString() {
            String string = new String();
            int n = 0;
            while (n < Symbows_Solitaire.this.length(this.cards)) {
                string = string + this.cards[n].toString() + '\n';
                ++n;
            }
            return string;
        }

        public String type() {
            return "Pile";
        }

        public boolean validate(Card card) {
            return card != null;
        }

        public boolean validate(Pile pile) {
            return false;
        }

        public boolean takeCardFromPile(Card card, Pile pile) {
            if (card != null) {
                Symbows_Solitaire.this.println(this.name + " tries to take " + card + " from " + pile.name());
                if (pile.hasCard(card) && (this.validate(card) || this.validate(pile))) {
                    Symbows_Solitaire.this.println(this.name + " takes " + card + " from " + pile.name());
                    this.add(pile.removeCard(card));
                    return true;
                }
                return false;
            }
            return false;
        }

        public boolean takeTopCardFromPile(Pile pile) {
            return this.takeCardFromPile(pile.topCard(), pile);
        }

        public Position getPos() {
            return this.pos;
        }

        public void moveTo(int n, int n2) {
            this.pos.moveTo(n, n2);
        }

        public void moveTo(Position position) {
            this.pos.moveTo(position);
        }

        public void update() {
            this.pos.update();
        }

        public int x() {
            return this.pos.x();
        }

        public int y() {
            return this.pos.y();
        }

        public Position pos() {
            return this.pos;
        }

        Pile(CardGame cardGame) {
            this.parent = cardGame;
            this.cards = null;
            this.name = null;
            this.pos = new Position();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CardGame {
        private int cursorPileIndex;
        private Cursor cursor;
        private Deck[] decks;
        private Hand hand;
        private Pile[] piles;
        private String state;

        public String state() {
            return this.state;
        }

        public void setState(String string) {
            this.state = string;
        }

        CardGame() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Hand
    extends Pile {
        private Pile src;
        private Pile dst;

        public void pickup(Pile pile) {
            if (!pile.empty()) {
                this.pickup(pile, pile.topCard());
            }
        }

        public void pickup(Pile pile, Card card) {
            this.src = pile;
            this.moveTo(pile.pos());
            boolean bl = false;
            int n = 1;
            while (!bl) {
                this.takeTopCardFromPile(pile);
                ++n;
                if (!super.topCard().equals(card)) continue;
                bl = true;
            }
            ((Pile)this).parent.setState("move");
        }

        public void drop(Pile pile) {
            if (!this.empty()) {
                this.dst = pile;
                if (pile.type().equals("Tableau")) {
                    if (pile.validate(this.topCard())) {
                        while (this.size() > 0) {
                            pile.takeTopCardFromPile(this);
                        }
                        if (this.src.type().equals("Tableau") && !this.src.empty()) {
                            this.src.topCard().turnFaceUp();
                        }
                    } else {
                        this.undo();
                    }
                } else if (pile.type().equals("Foundation")) {
                    if (pile.validate(this.topCard())) {
                        while (this.size() > 0) {
                            pile.takeTopCardFromPile(this);
                        }
                        if (this.src.type().equals("Tableau") && !this.src.empty()) {
                            this.src.topCard().turnFaceUp();
                        }
                    } else {
                        this.undo();
                    }
                } else {
                    this.undo();
                }
                ((Pile)this).parent.setState("choose");
            }
        }

        private final void undo() {
            ((Pile)this).parent.setState("undo");
            while (this.size() > 0) {
                this.src.takeTopCardFromPile(this);
            }
        }

        public boolean move(Pile pile, Pile pile2, Card card) {
            if (pile != pile2) {
                boolean bl = false;
                int n = 1;
                while (!bl) {
                    this.takeTopCardFromPile(pile);
                    ++n;
                    if (!super.topCard().equals(card)) continue;
                    bl = true;
                }
                n = 1;
                while (this.size() > 0) {
                    pile2.takeTopCardFromPile(this);
                }
                if (!pile.empty()) {
                    pile.topCard().turnFaceUp();
                }
                return true;
            }
            return false;
        }

        public void moveTo(int n, int n2) {
            super.moveTo(n, n2);
            if (!super.empty()) {
                int n3 = 0;
                while (n3 < Symbows_Solitaire.this.length(((Pile)this).cards)) {
                    ((Pile)this).cards[n3].moveTo(n - 24, n2 + n3 * 8 - 3, 4 + n3 / 2);
                    ++n3;
                }
            }
        }

        public void moveTo(Position position) {
            this.moveTo(position.x(), position.y());
        }

        public void draw() {
            if (!this.empty()) {
                int n = 0;
                while (n < Symbows_Solitaire.this.length(((Pile)this).cards)) {
                    ((Pile)this).cards[n].draw();
                    ++n;
                }
            }
        }

        public String type() {
            return "Hand";
        }

        Hand(Klondike klondike) {
            super(klondike);
            this.name = "Hand";
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Foundation
    extends Pile {
        private Rank base;
        private Suit suit;
        private int index;

        public boolean validate(Card card) {
            if (card != null) {
                if (this.empty()) {
                    return this.base.equals(card.rank());
                }
                return card.suit().equals(this.topCard().suit()) && card.value() - this.topCard().value() == 1;
            }
            return false;
        }

        public String name() {
            return this.name + ' ' + this.index;
        }

        public boolean setBase(Rank rank) {
            if (this.base == null) {
                this.base = rank;
                return true;
            }
            return false;
        }

        public String type() {
            return "Foundation";
        }

        public void draw() {
            if (!this.empty()) {
                int n = Symbows_Solitaire.this.length(((Pile)this).cards) - 1;
                while (n >= 0) {
                    ((Pile)this).cards[n].draw();
                    --n;
                }
            } else {
                ((Pile)this).drawEmpty();
            }
        }

        Foundation(Klondike klondike, Rank rank, int n) {
            super(klondike);
            this.base = rank;
            this.index = n;
            this.name = "Foundation " + this.index;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Rank {
        private int value;
        private String name;
        private String mark;

        public boolean equals(Rank rank) {
            boolean bl = false;
            if (this.value() == rank.value()) {
                bl = true;
            }
            return bl;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        Rank(int n, String string, String string2) {
            this.value = n;
            this.name = string;
            this.mark = string2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SuitColour {
        private int num;
        private String name;

        public String toString() {
            return this.name;
        }

        public int toColor() {
            switch (this.num) {
                case 0: {
                    return -65536;
                }
                case 1: {
                    return -16777216;
                }
            }
            return 0;
        }

        SuitColour(int n, String string) {
            this.num = n;
            this.name = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Suit {
        private int value;
        private String name;
        private SuitColour colour;

        public boolean equals(Suit suit) {
            boolean bl = false;
            if (this.value() == suit.value()) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return this.name;
        }

        public SuitColour colour() {
            return this.colour;
        }

        public int toColor() {
            return this.colour.toColor();
        }

        public int value() {
            return this.value;
        }

        Suit(int n, String string, SuitColour suitColour) {
            this.value = n;
            this.name = string;
            this.colour = suitColour;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Deck
    extends Pile {
        private SuitColour[] suitColours;
        private Suit[] suits;
        private Rank[] ranks;
        private PImage art;

        public PImage art() {
            return this.art;
        }

        public String type() {
            return "Deck";
        }

        Deck(CardGame cardGame) {
            super(cardGame);
            this.name = "Deck";
            ((Pile)this).cards = new Card[52];
            this.art = Symbows_Solitaire.this.loadImage("cards.png");
            this.suitColours = new SuitColour[2];
            this.suitColours[0] = new SuitColour(0, "Red");
            this.suitColours[1] = new SuitColour(1, "Black");
            this.suits = new Suit[4];
            this.suits[0] = new Suit(0, "Hearts", this.suitColours[0]);
            this.suits[1] = new Suit(1, "Spades", this.suitColours[1]);
            this.suits[2] = new Suit(2, "Diamonds", this.suitColours[0]);
            this.suits[3] = new Suit(3, "Clubs", this.suitColours[1]);
            this.ranks = new Rank[13];
            this.ranks[0] = new Rank(1, "Ace", "A");
            this.ranks[1] = new Rank(2, "Two", "2");
            this.ranks[2] = new Rank(3, "Three", "3");
            this.ranks[3] = new Rank(4, "Four", "4");
            this.ranks[4] = new Rank(5, "Five", "5");
            this.ranks[5] = new Rank(6, "Six", "6");
            this.ranks[6] = new Rank(7, "Seven", "7");
            this.ranks[7] = new Rank(8, "Eight", "8");
            this.ranks[8] = new Rank(9, "Nine", "9");
            this.ranks[9] = new Rank(10, "Ten", "10");
            this.ranks[10] = new Rank(11, "Jack", "J");
            this.ranks[11] = new Rank(12, "Queen", "Q");
            this.ranks[12] = new Rank(13, "King", "K");
            int n = 0;
            while (n < 4) {
                int n2 = 0;
                while (n2 < 13) {
                    ((Pile)this).cards[n * 13 + n2] = new Card(this, this.suits[n], this.ranks[n2]);
                    ++n2;
                }
                ++n;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Cursor {
        private PImage art;
        private Position pos;

        public void draw() {
            Symbows_Solitaire.this.image(this.art, this.pos.x, this.pos.y);
            this.pos.update();
        }

        public void moveTo(int n, int n2) {
            this.pos.moveTo(n, n2, 4);
        }

        public void moveTo(Position position) {
            this.moveTo(position.x, position.y);
        }

        public Position pos() {
            return this.pos;
        }

        Cursor() {
            this.pos = new Position(160, 240);
            this.art = Symbows_Solitaire.this.loadImage("cursor.png");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Card {
        private final Suit suit;
        private final Rank rank;
        private final Deck deck;
        private Position pos;
        boolean faceUp;

        public boolean equals(Card card) {
            return this.suit.equals(card.suit()) && this.rank.equals(card.rank());
        }

        public String toString() {
            return this.rank.toString() + " of " + this.suit.toString();
        }

        public Suit suit() {
            return this.suit;
        }

        public SuitColour suitColour() {
            return this.suit.colour();
        }

        public Rank rank() {
            return this.rank;
        }

        public int value() {
            return this.rank.value();
        }

        public boolean isFaceDown() {
            return this.faceUp ^ true;
        }

        public boolean isFaceUp() {
            return this.faceUp;
        }

        public void turnFaceDown() {
            this.faceUp = false;
        }

        public void turnFaceUp() {
            this.faceUp = true;
        }

        public void moveTo(int n, int n2) {
            this.moveTo(n, n2, 1);
        }

        public void moveTo(int n, int n2, int n3) {
            Symbows_Solitaire.this.println("move " + this + " to " + n + ", " + n2 + " in " + n3 + " steps");
            this.pos.moveTo(n, n2, n3);
        }

        public void moveTo(Position position) {
            this.moveTo(position.x(), position.y());
        }

        public void moveTo(Position position, int n) {
            this.moveTo(position.x(), position.y(), n);
        }

        public void draw() {
            Symbows_Solitaire.this.pushMatrix();
            Symbows_Solitaire.this.translate(this.pos.x, this.pos.y);
            if (this.faceUp) {
                int n = this.rank.value() - 1;
                if (n == 0) {
                    n = 13;
                }
                int n2 = this.suit.value();
                Symbows_Solitaire.this.image(this.deck.art(), n * 35 + 1, n2 * 47 + 1, 33, 45, 0, 0);
            } else {
                Symbows_Solitaire.this.image(this.deck.art(), 1, 1, 33, 45, 0, 0);
            }
            Symbows_Solitaire.this.popMatrix();
            this.pos.update();
        }

        public void drawMoving() {
            if (this.pos.state.equals("moving")) {
                this.draw();
            }
        }

        private final /* synthetic */ void this() {
            this.faceUp = false;
        }

        Card(Deck deck, Suit suit, Rank rank) {
            this.this();
            this.deck = deck;
            this.suit = suit;
            this.rank = rank;
            this.pos = new Position();
        }
    }
}

