
		; nexgen-texgen (64-byte intro for Sinclair ZX Spectrum 48)
		; (c) 2021, Milos Bazelides a.k.a. baze/3SC

		; Disclaimer: I'm not much into glitch coding but for Lovebyte 2022 I just gave it a go :)

		org	32768

		; BC = #8000 at this point.

		di
		ld	d,b
		ld	e,Script & 255

		; Initialize attributes.

		ld	h,#5B
ClearScreen	ld	(hl),%01010000
		dec	hl
		bit	3,h
		jr	nz,ClearScreen

MainLoop	ld	b,190

		; Update the dithering treshold.

DitherY		xor	%11000000
DitherX		xor	%10000000
		ld	l,a
		push	af

		; Calculate the pixel intensity, add a bit of "randomness" and dither.

		ld	a,h
		and	15
UpdateScript	sub	b
		sub	b
		rla
		cp	l
		jr	nc,DontDraw

		; Draw pixel reusing part of the PIXEL-ADD subroutine in ROM.

		push	hl
		ld	a,b
		call	8881
		ld	a,(hl)
		xor	d
		ld	(hl),a
		pop	hl
		inc	h

		; Make some noise and set the border color.

		and	%00010010
		out	(254),a

DontDraw	pop	af
		inc	h

		; Rotate the pixel mask in D and do the next pixel.

		rrc	d
		inc	c
		jr	nz,DitherX
		djnz	DitherY

		; Advance "script". D is already set to #80 where our code resides.

		ld	a,(de)
		ld	(UpdateScript),a
		inc	e
		jr	MainLoop

		; This is a sequence of 1-byte opcodes that we use to modify the texture generator.

Script		sub	c
		or	c
		or	b
		halt
