
		; spacedots (256-byte demo for Sinclair ZX Spectrum 128)
		; (c) 2022, Milos Bazelides a.k.a. baze/3SC

VramTab		equ	#84

StartAddr	equ	#8300 - RawSize + 1
		org	StartAddr

		; Reset frame counter (decompressor leaves BC = 0).

EntryPoint	ld	iyh,b

		; Generate pixel masks.

		ld	a,h
		ld	hl,VramTab * 256
GenPixel	rra
		ld	(hl),a
		jr	nc,GenNext
		rrca
GenNext		inc	l
		jr	nz,GenPixel

		; Generate lookup table for attribute and bitmap addresses.

GenVramAddr	ld	h,VramTab + 1
		ld	a,l
		ex	de,hl
		call	8880
		ex	de,hl
		ld	(hl),e
		inc	h
		ld	a,d
		or	128
		ld	(hl),a
		inc	h
		rra
		rra
		rra
		and	31
		or	#C0
		ld	(hl),a
		inc	l
		jr	nz,GenVramAddr

		; Enter the main loop and wait for vertical sync.

MainLoop	halt

		; Swap frame buffers.

SwapVram	ld	a,#5D
		xor	%1010
		ld	(SwapVram + 1),a
		out	(253),a

		; Clear screen (do it every 3rd frame to create motion blur).

		ld	bc,#0303
ClearCount	ld	a,1
		dec	a
		jr	nz,SkipClear

		ld	hl,#D800
ClearScreen	ld	(hl),a
		inc	l
		ld	(hl),a
		inc	l
		ld	(hl),a
		inc	l
		ld	(hl),a
		inc	l
		jr	nz,ClearScreen
		inc	h
		djnz	ClearScreen

		ld	a,c
SkipClear	ld	(ClearCount + 1),a

		; Process "script".

		ld	a,iyh
		or	a
		jr	z,Render

		; Begin vertical scroll and enable sound (ugly but packs well).

		ld	hl,PreStepY + 2
		dec	(hl)
		dec	(hl)
		dec	(hl)
		dec	(hl)
		dec	(hl)
		dec	(hl)

		ld	l,(PlaySound + 1) & 255
		ld	(hl),%00011000

		cp	c
		jr	c,Render

		; Generate pseudo-random horizontal acceleration (1 or -1).

RandomSeed	ld	hl,#B200
		add	hl,hl
		sbc	a,a
		and	#2D
		xor	l
		ld	l,a
		ld	(RandomSeed + 1),hl
		and	2
		dec	a

		; Accumulate velocity and position.

MoveCamera	ld	hl,#8000
		add	a,l
		ld	l,a
		add	a,h
		ld	h,a
		ld	(MoveCamera + 1),hl
		ld	(PreStepX + 2),a

		; Draw perspective layers.

Render		ld	ix,48 * 256 + 64
		ld	c,64 + 6
		call	RenderGrid

		ld	ix,32 * 256 + 43
		dec	c
		call	RenderGrid

		ld	ix,19 * 256 + 26
		dec	c
		dec	c
		call	RenderGrid

		; Increment frame counter and render the next frame.

		inc	iy
		jr	MainLoop

RenderGrid	; Calculate horizontal pre-step (IXL * H / 256).

		ld	e,ixl
PreStepX	ld	hl,#8000
		ld	d,l

		rept	8
		add	hl,hl
		jr	nc,$ + 3
		add	hl,de
		endr

		ld	a,h
		ld	(GridY + 1),a

		; Calculate vertical pre-step (IXH * H / 256).

		ld	e,ixh
PreStepY	ld	hl,#8000
		ld	d,l

		rept	8
		add	hl,hl
		jr	nc,$ + 3
		add	hl,de
		endr

		ld	d,h
GridY		ld	e,0

		or	ixl
PlaySound	and	0
		out	(254),a

		; Load pixel mask and video RAM addresses.

GridX		ld	h,VramTab
		ld	l,e
		ld	a,(hl)
		ex	af,af'
		ld	a,l
		inc	h
		rra
		rra
		rra
		and	31
		ld	l,d
		or	(hl)
		inc	h
		ld	b,(hl)
		inc	h
		ld	h,(hl)
		ld	l,a

		; Check whether we need to clear the attribute block before drawing.

		ld	a,(hl)
		or	a
		jr	nz,DrawPixel

		; Set color and clear the whole block.

		ld	(hl),c
		ld	a,b
		and	%11111000
		ld	h,a
		xor	a
		ld	(hl),a
		inc	h
		ld	(hl),a
		inc	h
		ld	(hl),a
		inc	h
		ld	(hl),a
		inc	h
		ld	(hl),a
		inc	h
		ld	(hl),a
		inc	h
		ld	(hl),a
		inc	h
		ld	(hl),a

		; Draw pixel.

DrawPixel	ld	h,b
		ex	af,af'
		or	(hl)
		ld	(hl),a

		; Horizontal grid step.

		ld	a,e
		add	a,ixl
		ld	e,a
		jr	nc,GridX

		; Vertical grid step.

		ld	a,d
		add	a,ixh
		ld	d,a
		cp	192
		jr	c,GridY

		ret

RawSize		equ	$ - EntryPoint

		export	StartAddr
		export	RawSize
