	org $0
screen		ds 2
frame		ds 2
idx1		ds 1
idx2		ds 1
idx3		ds 1
idx1glob	ds 1

screen0	equ $2020

xbuff	equ $7000
ybuff	equ #7100

width	equ	80
height	equ 51

	run	$200

Start::
	; pal init
	lda #0
	tay
	tax
pal_loop::
	sta	$fda0,x
	sta	$fdb0,x

	dey
	
	sta	$fda0+16-256,y
	sta	$fdb0+16-256,y

	inx
	adc	#$22

	bcc	pal_loop

	; snd init
	lda #%00111111
	sta $fd20	; vol
	sta $fd21	; shift register (sound type)
	sta $fd24	; freq
	lsr
	sta $fd20+8	; vol
	sta $fd21+8	; shift register (sound type)
	sta $fd24+8	; freq
	lda #%00011110
	sta $fd25	; ctrl
	sta $fd25+8	; ctrl	

	lda	#8<<4
	sta screen0+70-1+80+80*84
	sta screen0+70+80+80*84
	sta screen0+70+1+80+80*84

	sta screen0+70-1+80+1*160+80*84
	sta screen0+70+80+1*160+80*84
	sta screen0+70+1+80+1*160+80*84

	sta screen0+70-2+80+2*160+80*84
	sta screen0+70+80+2*160+80*84
	sta screen0+70+2+80+2*160+80*84

endless::
	inc	frame
	bne	noFrameInc
	lda	frame+1
	clc
	adc #1
	and #00000011
	sta frame+1
noFrameInc::

	lda idx1glob
	sta idx1
	sta idx2
	and #%00110000
	sta $fd24	; freq
	inc idx1glob

	lda	frame
	lsr
	lsr
	lsr
	tay
	lda	sin_tab1,y
	sta $fd24+8	; freq

	stz idx3

	ldx	#width
xbuffLoop::
	inc idx1
	lda idx1
	and	#%00011111
	tay
	lda	sin_tab1,y
	pha
	lda idx3
	clc
	adc frame+1
	sta idx3

	and	#%00011111
	tay
	pla
	clc
	adc sin_tab1,y
	sta xbuff,x
	dex
	bne xbuffLoop

	ldx	#height
ybuffLoop:
	inc idx2
	lda idx2
	and	#%00011111
	tay
	lda	sin_tab1,y
	sta ybuff,x
	dex
	bne ybuffLoop

	lda	#<screen0
	sta	$fd94
	sta screen
	sta screen+1
	sta	$fd95

	ldx	#height
lineLoop::
	ldy	#width

pxLoop::
	lda xbuff,y
	;clc
	adc ybuff,x
	and	#%00001111
	dey
	sta	(screen),y

	bne pxLoop
	
	lda screen
	adc #160
	sta screen
	bcc screen_ok             
    inc screen+1
screen_ok::
	
	dex
	bne lineLoop
	
	jmp endless

****************

sin_tab1 DB 8,9,11,12,13,14,15,15,15,15,15,14,13,12,11,9,8,7,5,4,3,2,1,1,0,1,1,2,3,4,5,7

End:
size	set End-Start
free	set 249-size

	IF free > 0
	REPT	free
	dc.b	0
	ENDR
	ENDIF

	echo "Size:%dsize  Free:%dfree"
