#version 330 core

uniform vec3 N;
uniform vec3 v;
layout(location = 0) in vec3 vertexPosition;
layout(location = 1) in vec2 vertexTexCoord;
layout(location = 2) in vec3 vertexNormal;
layout(location = 3) in vec4 vertexColor;

uniform mat4 mvp;
uniform mat4 view;
uniform mat4 model;
uniform mat4 projection;
uniform mat3 normalMatrix;
out vec2 texCoord;

void main()
{
   vec4 position = vec4(vertexPosition, 1);
   texCoord = vertexTexCoord;
   //v = vec3((model * view) * position);       
   N = normalize(normalMatrix * vertexNormal);
  
   gl_Position = mvp*position;
}