; "KBA-KBA"
; ZX Spectrum + AY 256b intro
; z80 code - .shahmatist
; zx2 code - .ded
; 09.09.2022, Samara, Russia
; https://emulate.su/rmda/KBA-KBA.zip
; =RMDA=

;---[Some tech info]--------------------------------------------

; 12b - IM2
; 13b - fake decruncher
; 14b - AY bytebit
; 06b - keyboard

; Follow the ../toolchan rabbit

	DEVICE	ZXSPECTRUM48

	org	#8000		; any #xx00 ORG is valid
		
begin:	equ $

color_tab:
;	DUP	2		;only first 48b of this table is
				;used, other just for alignment
	DUP	4

	defb	%00001010	; #12
	defb	%00011010	; #32
	defb	%00011100	; #34
	defb	%00101100	; #54
	defb	%00101110	; #56
	defb	%00001110	; #16
	defb	%00001010	; #12
	defb	%00011010	; 32
	defb	%00011100
	defb	%00101100
	defb	%00101110
	defb	%00001110
	defb	%00001010
	defb	%00011010
	defb	%00011100
	defb	%00101100
	defb	%00101110
	defb	%00001110
	defb	%00001010
	defb	%00011010
	defb	%00011100
	defb	%00101100
	defb	%00101110
	defb	%00001110

	EDUP

;	di			; bytefiller for extra safety
;---im2---------------------------------------------------------
	ld	b,#c9		;C=0 after ZX2 depacker sequence
	ld	a,b
	ld	i,a
	im	2
soop:	cp	b
	ld	(bc),a
	inc	bc
	jr	z,soop
;---border init-------------------------------------------------
	ld	ixh,c
;---fake decruncher---------------------------------------------
	ld	b,#1b		; #1B = DEC DE
fake:	
;	ld	sp,#5b01
	ld	hl,#5aff
;	ld	h,#5a
	cpl
;	push	af
	ld	(hl),a
;	out	(#fe),a		; EPILEPTIC VERSION
	ld	a,d
	or	e
	jr	nz,fake-1	; opcode reuse
	djnz	fake-1		; opcode reuse
;---------------------------------------------------------------

color_begin:

iteration_line:		

	ld	c,#01

	ld	l,c
	ld	a,c
	exx

	add	a,24

	ld	c,a
	ld	l,c
	exx

color_h2:

	ld	h,color_tab/256
	ld	d,(hl)
	ld	e,d

	exx

	ld	h,color_tab/256
	ld	a,(hl)
	exx

stack_right:		

	ld	sp,#5820		

	DUP	5
	push	de
	EDUP
	
	ld	d,a

	DUP	6
	push	de	
	EDUP

	ld	e,d

	DUP	5
	push	de	
	EDUP
		
	ld	hl,64
	add	hl,sp
		
	ld	(stack_right+1),hl
	inc	c
	ld	l,c
	exx
	dec	c
	ld	l,c
	exx

	jr	nz,color_h2
		
	ld	hl,#5820
	ld	(stack_right+1),hl
;---------------------------------------------------------------
	ld	hl,iteration_line+1
	ld	a,24
	inc	(hl)
	cp	(hl)
	jr	nz,color_h3
	ld	(hl),b			; B=#00
color_h3:
		
new_frame:

;---ay sound----------------------------------------------------
;	ld	e,h			; E=#0D for AY
	ld	h,#59

ayl:	ld	bc,#fffd
	out	(c),e
	ld	b,#bf
	outi
	dec	e
	jr	nz,ayl
;---------------------------------------------------------------
	ld	hl,#471f
	exx
	ld	hl,#4009
	exx
	ld	c,8

mask_line:
	ld	a,#ff
	cpl
	ld	d,a
	ld	e,d
	exx
	ld	d,a
	ld	e,d
	exx
	ld	(mask_line+1),a
right3:	

;---end of frame------------------------------------------------
	ld	sp,hl	; save byte but corrupt screen on pause
;	ld	sp,#DEDA

keys:	ei
	halt
;---keyboard----------------------------------------------------	
;	xor	a	; removing XOR gives additional FX for
	in	a,(#fe)	; keyboard - (L) for PAUSE, (A) for SLOW
	or	h	; OR %11100000
	inc	a
	jr	nz,keys
;---border sequence---------------------------------------------
	inc	ix
	ld	a,ixh
	out	(#fe),a
;---------------------------------------------------------------
right2:		
	ld	b,8
right:
	ld	sp,hl
	inc	sp

	DUP 5
	push	de
	EDUP

	DUP	11		;ld a,l : sub 11 : ld l,a
	dec	l
	EDUP

	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d		
	ld	a,d
	cpl
	ld	d,a
	ld	e,d

	ld	a,l : add a,53 : ld l,a
;	DUP	53 : inc l : EDUP

	djnz	right

	exx
	ld	b,8
left1:		
	ld	sp,hl
	inc	sp

	DUP 5
	push	de
	EDUP

	ld	hl,21
	add	hl,sp
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d

	ld	a,d
	cpl
	ld	d,a
	ld	e,d

	ld	a,l : add a,30 : ld l,a
;	DUP	30  : inc l : EDUP

	djnz	left1

	exx

	DUP	8		;ld a,8 : add a,h : ld h,a
	inc	h
	EDUP

right2_2:		
	ld	b,8
right_2:
	ld	sp,hl
	inc	sp

	DUP	5
	push	de
	EDUP

	DUP	11		;ld a,l : sub 11 : ld l,a
	dec	l
	EDUP

	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d		
	ld	a,d
	cpl
	ld	d,a
	ld	e,d

	ld	a,l : add a,53 : ld l,a
;	DUP	53 : inc l : EDUP

	djnz	right_2

	exx

	DUP	8		;ld a,#8 : add a,h : ld h,a
	inc	h 
	EDUP

	ld	b,8
left2:		
	
	ld	sp,hl
	inc	sp

	DUP	5
	push	de
	EDUP

	ld	hl,21
	add	hl,sp

	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	ld	a,d
	cpl
	ld	d,a
	ld	e,d

	ld	a,l  : add a,30 : ld l,a
;	DUP 30	: inc	l : EDUP

	djnz	left2
	exx
		
	DUP	8		;ld a,8 : add a,h : ld h,a
	inc	h
	EDUP

	ld	b,8

right2_3:		

	ld	sp,hl
	inc	sp

	DUP	5
	push	de
	EDUP

	DUP	11		;ld a,l : sub 11 : ld l,a
	dec	l
	EDUP

	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d		
	ld	a,d
	cpl
	ld	d,a
	ld	e,d

	ld	a,l
	add	a,53
	ld	l,a

	djnz	right2_3	

	exx

	DUP	8		;ld a,#8 : add a,h : ld h,a
	inc	h
	EDUP

	ld	b,8
left3:		
	ld	sp,hl		
	inc	sp

	DUP	5
	push	de
	EDUP

	ld	hl,21
	add	hl,sp
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	dec	l
	dec	l
	ld	(hl),d
	ld	a,d
	cpl
	ld	d,a
	ld	e,d		

	ld	a,l : add a,30 : ld l,a
;	DUP 30	: inc	l : EDUP

	djnz	left3

	DUP	#0f		;ld a,h : sub #0f : ld h,a
	dec	h       
	EDUP            

	exx

	out	(#fe),a		; !!! BORDER for 48K

	DUP	#11		;ld a,h : sub #11 : ld h,a
	dec	h
	EDUP

;!!	out	(#fe),a ;BORDER for Pentagon

	dec	c

	jp	nz,right3

	jp	color_begin

;---alignment---------------------------------------------------
	DUP	190
	defb	#80
	EDUP	
;---------------------------------------------------------------

fin:
	SAVESNA	"KBA-KBA-unpacked.sna", begin
	SAVEBIN	"KBA-KBA-unpacked.bin", begin,fin-begin

;-------=RMDA=---------------------------------------------[eof]