
#ifdef GL_ES
precision mediump float;
#endif

varying vec2 vTexCoord ;
// we need the sketch resolution to perform some calculations
uniform vec2 resolution ;
uniform float time ;
uniform vec2 mouse ;

uniform float seed ;

//ESTO ESTA EN CUALQUIERA ?!
uniform float pantallaactiva ; 
uniform float vueltas ; 



#define iTime time
#define iResolution resolution
#define PI 3.14159265359
#define OCTAVES 8

const float wave_amplitude = 0.076;
const float period = 2.*PI;

// Some useful functions
vec3 mod289(vec3 x) { return x - floor(x * (1.0 / 289.0)) * 289.0; }
vec2 mod289(vec2 x) { return x - floor(x * (1.0 / 289.0)) * 289.0; }
vec3 permute(vec3 x) { return mod289(((x*34.0)+1.0)*x); }

float wave_phase() {
    return iTime*.08;
}
float square(vec2 st) {
    vec2 bl = step(vec2(0.), st);       // bottom-left
    vec2 tr = step(vec2(0.),1.0-st);   // top-right
    return bl.x * bl.y * tr.x * tr.y;
}
float genR (in vec2 _st) {
    return fract(sin(dot(floor(_st.xy),
                         vec2(12.9898,78.233)))*
        43000.31);
}
float rdm(float p){
    p*=1234.56;
    p = fract(p * .1031);
    p *= p + 33.33;
    return fract(2.*p*p);
}
float noise (in vec2 st,float fase) {
    vec2 i = floor(st);
    vec2 f = fract(st);
    
    float fase2 = fase;
    // Four corners in 2D of a tile
    float a = sin(genR(i)*fase2);
    float b =  sin(genR(i + vec2(1.0, 0.0))*fase2);
    float c =  sin(genR(i + vec2(0.0, 1.0))*fase2);
    float d =  sin(genR(i + vec2(1.0, 1.0))*fase2);

    // Smooth Interpolation

    // Cubic Hermine Curve.  Same as SmoothStep()
    vec2 u = f*f*(3.0-2.0*f);
    // u = smoothstep(0.,1.,f);

    // Mix 4 coorners percentages
    return mix(a, b, u.x) +
            (c - a)* u.y * (1.0 - u.x) +
            (d - b) * u.x * u.y;
}
vec4 frame(vec2 st) {
    float tushka = square(st*mat2((1./.48), 0., 0., (1./.69)));
    
    mat2 sector_mat = mat2(1./.16, 0., 0., 1./.22);
    float sectors[4];
    sectors[0] = square(st * sector_mat + (1./.16)*vec2(0.000,-0.280));
    sectors[1] = square(st * sector_mat + (1./.16)*vec2(0.000,-0.060));
    sectors[2] = square(st * sector_mat + (1./.16)*vec2(-0.240,-0.280));
    sectors[3] = square(st * sector_mat + (1./.16)*vec2(-0.240,-0.060));
    vec3 sector_colors[4];
    sector_colors[0] = vec3(0.941, 0.439, 0.404) * sectors[0];
    sector_colors[1] = vec3(0.435, 0.682, 0.843) * sectors[1];
    sector_colors[2] = vec3(0.659, 0.808, 0.506) * sectors[2];
    sector_colors[3] = vec3(0.996, 0.859, 0.114) * sectors[3];
    
    return vec4(vec3(sector_colors[0] + sector_colors[1] +
                     sector_colors[2] + sector_colors[3]), tushka);
}

vec4 trail_piece(vec2 st, vec2 index, float scale) {
    scale = index.x * 0.082 + 0.452;
    
    vec3 color;
    if (index.y > 0.9 && index.y < 2.1 ) {
        color = vec3(0.435, 0.682, 0.843);
        scale *= .8;
    } else if (index.y > 3.9 && index.y < 5.1) {
        color = vec3(0.941, 0.439, 0.404);
        scale *= .8;
    } else {
        color = vec3(0., 0., 0.);
    }
    
    float scale1 = 1./scale;
    float shift = - (1.-scale) / (2. * scale);
    vec2 st2 = vec2(vec3(st, 1.) * mat3(scale1, 0., shift, 0., scale1, shift, 0., 0., 1.));
    float mask = square(st2);

    return vec4( color, mask );
}

vec4 trail(vec2 st) {
    // actually 1/width, 1/height
    const float piece_height = 7. / .69;
    const float piece_width = 6. / .54;
  
    // make distance between smaller segments slightly lower
    st.x = 1.2760 * pow(st.x, 3.0) - 1.4624 * st.x*st.x + 1.4154 * st.x;
    
    float x_at_cell = floor(st.x*piece_width)/piece_width;
    float x_at_cell_center = x_at_cell + 0.016;
    float incline = cos(0.5*period + wave_phase()) * wave_amplitude;
    
    float offset = sin(x_at_cell_center*period + wave_phase())* wave_amplitude + 
        incline*(st.x-x_at_cell)*5.452;
    
    float mask = step(offset, st.y) * (1.-step(.69+offset, st.y)) * step(0., st.x);
    
    vec2 cell_coord = vec2((st.x - x_at_cell) * piece_width,
                           fract((st.y-offset) * piece_height));
    vec2 cell_index = vec2(x_at_cell * piece_width, 
                           floor((st.y-offset) * piece_height));
    
    vec4 pieces = trail_piece(cell_coord, cell_index, 0.752);
    
    return vec4(vec3(pieces), pieces.a * mask);
}
float snoise(vec2 v) {
    // Precompute values for skewed triangular grid
    const vec4 C = vec4(0.211324865405187,
                        // (3.0-sqrt(3.0))/6.0
                        0.366025403784439,
                        // 0.5*(sqrt(3.0)-1.0)
                        -0.577350269189626,
                        // -1.0 + 2.0 * C.x
                        0.024390243902439);
                        // 1.0 / 41.0

    // First corner (x0)
    vec2 i  = floor(v + dot(v, C.yy));
    vec2 x0 = v - i + dot(i, C.xx);

    // Other two corners (x1, x2)
    vec2 i1 = vec2(0.0);
    i1 = (x0.x > x0.y)? vec2(1.0, 0.0):vec2(0.0, 1.0);
    vec2 x1 = x0.xy + C.xx - i1;
    vec2 x2 = x0.xy + C.zz;

    // Do some permutations to avoid
    // truncation effects in permutation
    i = mod289(i);
    vec3 p = permute(
            permute( i.y + vec3(0.0, i1.y, 1.0))
                + i.x + vec3(0.0, i1.x, 1.0 ));

    vec3 m = max(0.5 - vec3(
                        dot(x0,x0),
                        dot(x1,x1),
                        dot(x2,x2)
                        ), 0.0);

    m = m*m ;
    m = m*m ;

    // Gradients:
    //  41 pts uniformly over a line, mapped onto a diamond
    //  The ring size 17*17 = 289 is close to a multiple
    //      of 41 (41*7 = 287)

    vec3 x = 2.0 * fract(p * C.www) - 1.0;
    vec3 h = abs(x) - 0.5;
    vec3 ox = floor(x + 0.5);
    vec3 a0 = x - ox;

    // Normalise gradients implicitly by scaling m
    // Approximation of: m *= inversesqrt(a0*a0 + h*h);
    m *= 1.79284291400159 - 0.85373472095314 * (a0*a0+h*h);

    // Compute final noise value at P
    vec3 g = vec3(0.0);
    g.x  = a0.x  * x0.x  + h.x  * x0.y;
    g.yz = a0.yz * vec2(x1.x,x2.x) + h.yz * vec2(x1.y,x2.y);
    return 130.0 * dot(m, g);
}

vec4 logo(vec2 st) {
    if (st.x <= .54) {
        return trail(st);
    } else {
        vec2 st2 = st + vec2(0., -sin(st.x*period + wave_phase())*wave_amplitude);
        return frame(st2 + vec2(-.54, 0));
    }
}

float fbm (in vec2 uv,in float _time) {
    // Initial values
    float value = 0.5;
    float amplitude = 0.5;
    float frequency = 0.;
    vec2 shift = vec2(100);
    mat2 rot2 = mat2(cos(0.5), sin(0.5),
                    -sin(0.5), cos(0.50));
    // Loop of octaves
    for (int i = 0; i < 16; i++) {
        value += amplitude * noise(uv,_time);
        uv = rot2 * uv * 2.0 + shift;
        amplitude *= .5;
    }
    return value;
}
mat2 scale(vec2 _scale){
    return mat2(_scale.x,0.0,
                0.0,_scale.y);
}
mat2 rotate2d(float _angle){
    return mat2(cos(_angle),-sin(_angle),
                sin(_angle),cos(_angle));
}
float ridge(float h, float offset) {
    h = abs(h);     // create creases
    h = offset - h; // invert so creases are at top
    h = h * h;      // sharpen creases
    return h;
}

#define OCTAVES 8
float ridgedMF(vec2 p) {
    float lacunarity = 2.0;
    float gain = 0.5;
    float offset = 0.9;

    float sum = 0.0;
    float freq = 1.0, amp = 0.5;
    float prev = 1.0;
    for(int i=0; i < OCTAVES; i++) {
        float n = ridge(snoise(p*freq+seed*20.), offset);
        sum += n*amp;
        sum += n*amp*prev;  // scale by previous octave
        prev = n;
        freq *= lacunarity;
        amp *= gain;
    }
    return sum;
}
/********************************************************************************************************/
//CIELO DE LA PANTALLA 
vec3 pantalla1(){
	vec2 uv = gl_FragCoord.xy/iResolution.xy;
	
	uv = vTexCoord;
	vec3 c1 = vec3(0.0,0.71,0.8);
	vec3 c2 = vec3(0.0,0.61,0.8);
	vec3 kc2 = vec3(103./255.,203./255.,151./255.); // verde
	vec3 kc3 = vec3(0.64,0.0,0.0); //rojo
	vec3 kc4 = vec3(.2); //gris
	float e = fbm(vec2(uv.x*0.2,uv.y*0.2),time*0.001+985.*seed);
	float e2 = fbm(vec2(uv.x*0.4,uv.y*0.4),time*0.001+413.*seed);
	float idx = floor(rdm(seed*145.)*3.);
	c1 = mix(vec3(1.0),c2,e2);	
	e = sin(e*10.+time*.0001)*.5+.5;
	vec3 fin = mix(c1,c2,e)*1.0;
	return fin; 
}

vec3 pantalla2(){
	vec2 uv = gl_FragCoord.xy/iResolution.xy;
	
	uv = vTexCoord;
	vec3 c1 = vec3(0,120./255.,215./255.);
	vec3 c2 = vec3(0,120./255.,215./255.)*.5;
	vec3 c3 = vec3(103./255.,203./255.,151./255.);
	vec3 kc2 = vec3(103./255.,203./255.,151./255.); // verde
	vec3 kc3 = vec3(0.64,0.0,0.0); //rojo
	vec3 kc4 = vec3(.2); //gris
	float e = fbm(vec2(uv.x*0.6,uv.y*0.6),time*0.001+985.*seed);
	float e2 = fbm(vec2(uv.x*100.,uv.y*100.),time*0.001+413.*seed);
	float idx = floor(rdm(seed*145.)*3.);
	vec3 fin = mix(c1,c2,e)*1.0;
	float ln = ridgedMF(uv*1.);
	ln-= sin(ln*100.+time)*.5+.5;
	ln = smoothstep(0.8,0.99,ln);
	fin = mix(fin,mix(c3,fin,.85),ln);
	vec3 dib2 = vec3(1.-smoothstep(0.001,0.00009,e2));
	return fin; 
}
vec3 pantalla3(){
	vec2 uv = gl_FragCoord.xy/iResolution.xy;
	
	
	uv = vTexCoord;
	vec3 kc2 = vec3(103./255.,203./255.,151./255.); // verde
	vec3 kc3 = vec3(0.09,0.0,0.0); //rojo
	vec3 kc4 = vec3(0.); //gris
	float e2 = fbm(vec2(uv.x*10.8,uv.y*10.8),time*0.001+413.*seed);
	vec3 fin = mix(kc3,kc4,1.-e2);
	return fin; 
}

vec3 pantalla1_2(){
	vec2 uv = gl_FragCoord.xy/iResolution.xy;
	
	uv = vTexCoord;
	vec3 c1 = vec3(0.0,0.71,0.8);
	vec3 c2 = vec3(0.64,0.0,0.0);
	vec3 kc2 = vec3(103./255.,203./255.,151./255.); // verde
	vec3 kc3 = vec3(0.64,0.0,0.0); //rojo
	vec3 kc4 = vec3(.2); //gris
	float e = fbm(vec2(uv.x*0.2,uv.y*0.2),time*0.001+985.*seed);
	float e2 = fbm(vec2(uv.x*0.4,uv.y*0.4),time*0.001+413.*seed);
	float idx = floor(rdm(seed*145.)*3.);
	c1 = mix(vec3(1.0),c2,e2);	
	e = sin(e*10.+time*.0001)*.5+.5;
	vec3 fin = mix(c1,c2,e)*1.0;
	return fin; 
}
void main() {
	
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
	uv = vTexCoord;
	vec3 fin = vec3(uv.x,uv.y,0.0);
	
	if(vueltas == 0.0){
		if(pantallaactiva == 0.){
			fin = pantalla1();
		}
		if(pantallaactiva == 1.){
			fin = pantalla2();
		}
		if(pantallaactiva == 2.){
			fin = pantalla3();
		}
	}else{
		if(pantallaactiva == 0.){
			fin = pantalla1_2();
		}
		if(pantallaactiva == 1.){
			fin = pantalla2();
		}
		if(pantallaactiva == 2.){
			fin = pantalla3();
		}
	}
	
	gl_FragColor = vec4(fin,1.0);
}