#version 330 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec3 aNormal;
layout (location = 2) in vec2 aTexCoords;

out vec2 TexCoords;
out vec3 WorldPos;
out vec3 Normal;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;
uniform float time;
float bpm =  128./60.;
float sync = floor(time*bpm);
void main()
{
	vec4 box1 = projection * view * model * vec4(aPos, 1.0f);
	vec4 box2 = projection * view * model * vec4(sin(aPos), 1.0f);
	if(time < 7)box1 = box1 + pow(atan(time)*box2, vec4(2.0));
	if(time > 7 && time < 15)box1 = box1 + pow(atan(time)*box2, vec4(dot(atan(gl_VertexID*aPos.y)*.05, aPos.z)));
	if(time > 15)box1 = box1 - pow(atan(time)/box2, vec4(dot((gl_VertexID*aPos.y)*.05, aPos.z)));
	box2 = box2 - (1.-length(box1)*.1) *sin(sync);
	gl_Position = mix(box1, box2, sin(time));
}