#version 330 core
out vec4 FragColor;

in vec3 ourColor;
in vec2 TexCoord;
in vec4 glitch;
in vec3 hello;
uniform vec2 u_resolution;
uniform float time;

// texture sampler
uniform sampler2D texture2;

void main()
{
	vec2 coffee = vec2(TexCoord.x / normalize (glitch.z), TexCoord.y / sin(gl_FragDepth));
	if(time > 12)
	{
	FragColor = texture(texture2, TexCoord);
	FragColor.x = sin(gl_FragDepth), TexCoord.y * normalize(hello.x);
	}
	
	if(time < 12)
	{
	FragColor = texture(texture2, TexCoord) -distance(normalize(hello.z), (gl_FragDepth) );
	}
}