
;
; This is a part of fischinger project
;
; I take the code from ZX Spectrum Vector Output Routines by [Dean Belfield]
;


;;;;;;;;;;;;;;;;;;;;;;;
; Draw_Line
; B = Y pixel position 1
; C = X pixel position 1
; D = Y pixel position 2
; E = X pixel position 2
;;;;;;;;;;;;;;;;;;;;;;;
Draw_Line:		LD A,D				; Check whether we are going to be drawing up
			CP B
			JR NC,Draw_Line_1

			PUSH BC				; If we are, then this neat trick swaps BC and DE
			PUSH DE				; using the stack, forcing the line to be always
			POP BC				; drawn downwards
			POP DE

Draw_Line_1:		; mark upper point
			ld hl, (upper_point_lower_point)
			ld a, h
			cp b ; check if h is smaller than b
			jr c, mark_upper_point_skip1
			ld h, b ; clamp it up if it is not
			ld (upper_point_lower_point), hl
mark_upper_point_skip1:
			
			ld hl, (upper_point_lower_point)
			ld a, d
			cp l ; check if l is greater then d
			jr c, mark_upper_point_skip2
			ld l, d ; clamp it down if it is not
			inc l
			ld (upper_point_lower_point), hl
mark_upper_point_skip2:
			
			CALL Get_Pixel_Address ; get position inside of byte
			ld h, b ; save running coordinates into hl
			ld l, c

			LD IX,Plot_Point		; Point to the Plot_Point table
			ADD A,IXL			; Add the pixel position to get entry in table
			LD IXL,A

			LD A,D				; Calculate the line height in B (Y2-Y1)
			SUB B
			LD B,A
	
			LD A,E				; Calculate the line width in C (X2-X1)
			SUB C
			JR C,Draw_Line_X1		; If carry set (negative result) then we are drawing from right to left
;
; This bit of code mods the main loop for drawing left to right
;
			LD C,A				; Store the line width
			LD A,0x2C			; Code for INC L
			LD (Draw_Line_Q1_M3),A		; Mod the code
			LD (Draw_Line_Q2_M3),A
			LD A,0x0A			; Code for RRC D (CB 0A)
			JR Draw_Line_X2			; Skip the next bit
;
; This bit of code mods the main loop for drawing right to left
;
Draw_Line_X1:		NEG				; The width of line is negative, so make it positive again
			LD C,A				; Store the line width
			LD A,0x2D			; Code for DEC L
			LD (Draw_Line_Q1_M3),A
			LD (Draw_Line_Q2_M3),A
			LD A,0x02			; Code for RLC D (CB 02)
;
; We've got the basic information at this point
;
Draw_Line_X2:		LD (Draw_Line_Q1_M2 + 1),A	; A contains the code for RLC D or RRC D, so make the mods
			LD (Draw_Line_Q2_M2 + 1),A
			LD D,(IX+0)			; Get the pixel data from the Point_Plot table
			LD A,B				; Check if B and C are 0
			OR C
			JR Z,Draw_Line_P		; There is no line, so just plot a single point
;
; At this point
; HL = .. the running coordinates (H = Y, L = X)
;  B = Line height (YL)
;  C = Line width (XL)
;  D = Pixel data
;
Draw_Line_Q:		LD A,B				; Work out which diagonal we are on
			CP C
			JR NC,Draw_Line_Q2
;
; This bit of code draws the line where B<C (more horizontal than vertical)
;
Draw_Line_Q1:		LD A,C				; A = XL
			LD (Draw_Line_Q1_M1 + 1),A	; Self-mod the code to store XL in loop
			LD C,B				; C = YL
			LD B,A				; B = XL (loop counter)
			LD E,B				; E = XL
			SRL E				; E = XL / 2 (error)
Draw_Line_Q1_L:		call silkscreen_plot		; plot the pixel (debug)
			LD A,E				; Add the line height to the error (E = E - YL)
			SUB C
			LD E,A
			JR NC,Draw_Line_Q1_M2
Draw_Line_Q1_M1:	ADD A,0				; Add the line width to the error (E = E + XL) - previously self-modded
			LD E,A
			inc h ; step down one line
Draw_Line_Q1_M2:	RRC D				; Rotate the pixel right or left; more self-modifying code
			;JR NC,Draw_Line_Q1_S
Draw_Line_Q1_M3:	INC L				; If we get a carry then move to adjacent screen address; more self modifying code
Draw_Line_Q1_S:		DJNZ Draw_Line_Q1_L		; Loop until the line is drawn
Draw_Line_P:		call silkscreen_plot
			RET
;
; This bit draws the line where B>=C (more vertical than horizontal, or diagonal)
;
Draw_Line_Q2:		LD (Draw_Line_Q2_M1 + 1),A	; Self-mod the code to store YL in loop
			LD E,B				; E = YL
			SRL E				; E = YL / 2 (error)
Draw_Line_Q2_L:		call silkscreen_plot		; plot the pixel

			LD A,E				; Add the line width to the error
			SUB C				; 
			JR NC,Draw_Line_Q2_S		; Skip the next bit if we don't get a carry
Draw_Line_Q2_M1: 	ADD A,0				; Add the line height to the error (E = E + XL) - previously self-modded
Draw_Line_Q2_M2:	RRC D				; Rotates the pixel right with carry
			; JR NC,Draw_Line_Q2_S
Draw_Line_Q2_M3:	INC L				; If we get a carry then move to adjacent screen address; more self modifying code
Draw_Line_Q2_S:		LD E,A				; Store the error value back in
			inc h ; down to next line
			DJNZ Draw_Line_Q2_L
			JR Draw_Line_P			; Plot the final point


;;;;;;;;;;;;;;;;;;;;;;;;
; silkscreen_plot
; hl - running coordinates (h = Y, l = X)
;;;;;;;;;;;;;;;;;;;;;;;;
silkscreen_plot:
		push bc
		push de
		push hl
		
		ld b, h
		ld c, l ; save coordinates
		
		ld d, 0
		ld e, b
		ld hl, silk_data
		add hl, de
		add hl, de ; get the address of silk line
		ld d, (hl) ; left point
		inc hl
		ld e, (hl) ; right point (not included in drawing)
		dec hl
		
		; d = left point to be compared
		; e = right point to be compared
		; b = vertical coordinate
		; c = horizontal coordinate
		; hl = pointer to the silk_data
		ld a, c
		cp d
		jr nc, silkscreen_plot_skip1
		ld (hl), c
silkscreen_plot_skip1:
		ld a, c
		cp e
		jr c, silkscreen_plot_skip2
		inc hl
		inc c ; move coordinate right
		ld (hl), c
silkscreen_plot_skip2:
		
		pop hl
		pop de
		pop bc
		ret


;;;;;;;;;;;;;;;;;;;;;;
; variables
;;;;;;;;;;;;;;;;;;;;;;
running_x: BYTE 0
enable_seeking: BYTE 0

;;;;;;;;;;;;;;;;;;;;;;
; assembler_left_mask
;;;;;;;;;;;;;;;;;;;;;;
	ALIGN 8
assembler_left_mask: BYTE 0b11111111, 0b01111111, 0b00111111, 0b00011111
	BYTE 0b00001111, 0b00000111, 0b00000011, 0b00000001
assembler_right_mask: BYTE 0b00000000, 0b10000000, 0b11000000, 0b11100000
	BYTE 0b11110000, 0b11111000, 0b11111100, 0b11111110

;;;;;;;;;;;;;;;;;;;;;;;;
; silkscreen_assembler
; returns HL - address of figurine drawing code
;;;;;;;;;;;;;;;;;;;;;;;;
silkscreen_assembler:
	ld hl, (upper_point_lower_point)
	ex de, hl
	ld ix, silk_data
	ld e, d
	ld d, 0
	add ix, de
	add ix, de ; ix = figure top address in the silk_data
	ld b, e    ; b = Y coordinate counter
	
	ld a, (ix+0)
	ld (upper_point_x), a
	
	ld hl, (upper_point_lower_point)
	ld a, l
	sub b
	ld c, a    ; c = figure height
	ld hl, (drawing_code_vault_running_w)
	
	push hl ; address of drawing code to be returned
	
	ld a, (upper_point_x)
	and 0b11111000
	ld (running_x), a
	
silkscreen_assembler_c1:
	ld a, 1
	ld (enable_seeking), a
	;ld a, (ix+0) ; left point
	;ld d, a
	;ld a, (ix+1) ; right point
	;sub d
	;jp c, silkscreen_assembler_empty_mask ; invalid line
	
silkscreen_assembler_seek_again1:
	or a ; clear carry flag
	ld de, wraparound_area
	sbc hl, de
	add hl, de ; compare two words
	call nc, assembler_make_wraparound

	; compute left edge
	ld a, (running_x)
	ld d, a
	ld a, (ix+0) ; left point
	sub d
	ld d, a ; save difference
	jr nc, silkscreen_assembler_skip_nowhite1
	ld a, (enable_seeking)
	or a
	jr z, silkscreen_assembler_skip_disabled1
	; step left
	ld a, (running_x)
	sub 8
	ld (running_x), a
	ld (hl), #2d ; dec l
	inc hl
	
	jr silkscreen_assembler_seek_again1
silkscreen_assembler_skip_disabled1:
	ld e, #ff ; load white byte
	jr silkscreen_assembler_go_check_second
silkscreen_assembler_skip_nowhite1:
	
	xor a
	ld (enable_seeking), a ; disable seeking
	ld a, d
	and 0b11111000
	jr nz, silkscreen_assembler_skip_nomask1
	ld a, d ; it must be from 0 to 7 right now
	ld de, assembler_left_mask
	add e
	ld e, a
	ld a, (de) ; load mask
	ld e, a
	
	jr silkscreen_assembler_go_check_second
	
silkscreen_assembler_skip_nomask1:
	; the black byte
	; step right
	ld a, (running_x)
	add 8
	ld (running_x), a
	ld (hl), #2c ; inc l
	inc hl
	jr silkscreen_assembler_seek_again1
	
silkscreen_assembler_go_check_second:
	; right edge this time
	ld a, (running_x)
	ld d, a
	ld a, (ix+1) ; right point
	sub d
	jr nc, silkscreen_assembler_no_seek2
	xor a
	ld e, a ; byte is black for sure
	jr silkscreen_assembler_empty_mask
	
silkscreen_assembler_no_seek2:
	ld d, a
	and 0b11111000
	jr z, silkscreen_assembler_nowhite2
	; ld a, e
	; and #ff
	; ld e, a ; second mask says byte is white
	jr silkscreen_assembler_mask_ready
silkscreen_assembler_nowhite2:
	ld a, d ; it must be from 0 to 7 right now
	push de
	ld de, assembler_right_mask
	add e
	ld e, a
	ld a, (de) ; load mask
	pop de
	and e ; combine two masks here
	ld e, a
	
silkscreen_assembler_mask_ready:
	ld a, e
	and a
	jr z, silkscreen_assembler_empty_mask
	; draw the byte
	; TODO detect white byte
	ld (hl), #3e ; ld a, *
	inc hl
	ld (hl), e ; save mask byte
	inc hl
	; ld (hl), #b6 ; or (hl) ; read from screen
	; inc hl
	ld (hl), #a0 ; and b
	inc hl
	ld (hl), #77 ; ld (hl), a ; write to the screen
	inc hl
	;ld (hl), #cd ; call
	;inc hl
	;ld (hl), low busy_wait
	;inc hl
	;ld (hl), high busy_wait
	;inc hl
	
	; step right
	ld a, (running_x)
	add 8
	ld (running_x), a
	ld (hl), #2c ; inc l
	inc hl
	
	jp silkscreen_assembler_seek_again1
	
silkscreen_assembler_empty_mask:
	; TODO revoke right step
	ld (hl), #cd ; call
	inc hl
	ld (hl), low Pixel_Address_Down
	inc hl
	ld (hl), high Pixel_Address_Down
	inc hl
	
	or a ; clear carry flag
	ld de, wraparound_area
	sbc hl, de
	add hl, de ; compare two words
	call nc, assembler_make_wraparound
	
	inc ix
	inc ix
	inc b
	dec c
	
	jp nz, silkscreen_assembler_c1 
	
	ld (hl), #c9 ; ret
	inc hl
	
	ld (drawing_code_vault_running_w), hl
	pop hl
	; return hl
	ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; assembler_make_wraparound
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
assembler_make_wraparound:
	;push hl
	;ld hl, #5900
	;ld (hl), 0b00111111 ; debug square
	;pop hl
	
	;push hl
	;ld hl, #5900
	;ld (hl), 0b00111111 ; debug square
	;pop hl
	
	ld (hl), #c3 ; jp
	inc hl
	ld (hl), low drawing_code_vault
	inc hl
	ld (hl), high drawing_code_vault
	inc hl
	ld hl, drawing_code_vault
	ret



