;UPKR promo title screen

	DEVICE	ZXSPECTRUM48

	org	40000

begin:	equ	$

	jp	launch

screen:	INCBIN "a000.C.zx0"        

launch:	
	ei
	halt
;-------CLS-----------------------------------------------------
	xor	a
	out	(#fe),a
	ld	hl,#5b00
cls:	dec	hl
	ld	(hl),a
	or	(hl)
	jr	z,cls
;---------------------------------------------------------------
	ld	hl,screen
	ld	de,#4000
	call	dzx0_standard
;---------------------------------------------------------------
	ret

;---------------------------------------------------------------
; ZX0 decoder by Einar Saukas & Urusergi
; "Standard" version (68 bytes only)
;---------------------------------------------------------------
; Parameters:
;   HL: source address (compressed data)
;   DE: destination address (decompressing)
;---------------------------------------------------------------

dzx0_standard:
        ld      bc, $ffff               ; preserve default offset 1
        push    bc
        inc     bc
        ld      a, $80
dzx0s_literals:
        call    dzx0s_elias             ; obtain length
        ldir                            ; copy literals
        add     a, a                    ; copy from last offset or new offset?
        jr      c, dzx0s_new_offset
        call    dzx0s_elias             ; obtain length
dzx0s_copy:
        ex      (sp), hl                ; preserve source, restore offset
        push    hl                      ; preserve offset
        add     hl, de                  ; calculate destination - offset
        ldir                            ; copy from offset
        pop     hl                      ; restore offset
        ex      (sp), hl                ; preserve offset, restore source
        add     a, a                    ; copy from literals or new offset?
        jr      nc, dzx0s_literals
dzx0s_new_offset:
        pop     bc                      ; discard last offset
        ld      c, $fe                  ; prepare negative offset
        call    dzx0s_elias_loop        ; obtain offset MSB
        inc     c
        ret     z                       ; check end marker
        ld      b, c
        ld      c, (hl)                 ; obtain offset LSB
        inc     hl
        rr      b                       ; last offset bit becomes first length bit
        rr      c
        push    bc                      ; preserve new offset
        ld      bc, 1                   ; obtain length
        call    nc, dzx0s_elias_backtrack
        inc     bc
        jr      dzx0s_copy
dzx0s_elias:
        inc     c                       ; interlaced Elias gamma coding
dzx0s_elias_loop:
        add     a, a
        jr      nz, dzx0s_elias_skip
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
dzx0s_elias_skip:
        ret     c
dzx0s_elias_backtrack:
        add     a, a
        rl      c
        rl      b
        jr	dzx0s_elias_loop
;---------------------------------------------------------------
fin:
;-----comment this for Pasmo or uncomment for SjAsm-------------
	SAVESNA	"screen.sna", launch
	SAVEBIN	"screen", begin,fin-begin
	EMPTYTRD "upkrpromo.trd","UPKR"
;	SAVETRD	"upkrpromo.trd","screen.C",begin,fin-begin
	display "addr: ",/A,launch
;-------=RMDA=---------------------------------------------[eof]