'use strict'

modules['tunnel'] = {
    config: [
        ['roll', 'angle', 0],
        ['distance', 'float', 0],
        ['brightness', 'float', 0.025],
        ['texture', 'texture', 'default'],
    ],

    render: async (time, self, config) => {
        const {
            distance,
            brightness,
            texture,
        } = { ...config }
        let {
            roll,
        } = { ...config }
        roll += 1000
        const texSize = texture.size
        const texData = texture.data

        const greyscaleBuffer = greyscaleBuffers[getOutputBufferId()]
        let CONE_RADIUS = 256
        const origin = [0, 0, 0]
        let index = 0

        const iHalfWidth = 1 / 240
        const iHalfHeight = 1 / 320
        const iUScaler = 1 / 20000
        const iVScaler = 6 * 1 / Math.PI

        for (let y = 0; y < 480; ++y) {
            for (let x = 0; x < 640; ++x) {
                let direction = [(x - 320) * iHalfWidth, (y - 240 ) * iHalfHeight, 1.0, 1.0]
                direction = m4.transformVector(camViewPersp, direction)

                const a = (direction[0]*direction[0]) + (direction[1]*direction[1])
                const b = 2*(origin[0]*direction[0] + origin[1]*direction[1])
                const c = (origin[0]*origin[0]) + (origin[1]*origin[1]) - (CONE_RADIUS*CONE_RADIUS)
            
                const delta = Math.sqrt(b*b - 4*a*c)

                const t = (-b + delta) / (2*a)
                //const t2 = (-b - delta) / (2*a)
                //const t = Math.max(t1, t2)

                const intersect = [origin[0] + direction[0]*t, origin[1] + direction[1]*t, origin[2] + direction[2]*t]
            
                let u = Math.abs(intersect[2]*iUScaler + distance) // 400 = y scale
                let v = Math.abs(Math.atan2(intersect[1], intersect[0])*iVScaler) // 8 = x scale
                let z = 3000 / t

                let tu = Math.floor((u%1) * texSize) //ang*60 = distance
                if (direction[2] > 0) {
                    tu = (texSize-1) - tu
                }
                let tv = (Math.sign(intersect[1])*v + roll*2) % 1
                tv = Math.floor(tv * texSize)
                const greyscale = texData[tu + tv * texSize]

                greyscaleBuffer[index++] = greyscale * (z*z) * brightness
            }
        }
    }
}
