'use strict'

modules['renderState'] = {
    config: [
        ['renderStyle', 'string', 'additive'],
        ['clearDepthBuffer', 'boolean', false],
        ['rasterMask', 'int', 0],
        ['nearDistance', 'float', 0],
        ['farDistance', 'float', 50],
        ['nearBrightness', 'float', 1],
        ['farBrightness', 'float', 1],
        ['originOffset', 'float2', [0, 0]],
        ['displayPort', 'float4', [0, 0, 639, 479]],
    ],

    render: async (time, self, config) => {
        const {
            renderStyle,
            clearDepthBuffer,
            rasterMask,
            nearDistance,
            farDistance,
            nearBrightness,
            farBrightness,
            originOffset,
            displayPort,
        } = { ...config }

        renderer.setOrigin([319 + originOffset[0], 239 + originOffset[1]])
        renderer.setRenderStyle(renderStyle)
        if (clearDepthBuffer) {
            renderer.clearDepthBuffer()
        }
        renderer.setRasterMask(rasterMask)
        renderer.setDepthBrightness(nearDistance, farDistance, nearBrightness, farBrightness)
        renderer.setDisplayPort(displayPort)
    }
}
