'use strict'

modules['noiseBackground'] = {
    config: [
        ['animation1', 'float', 0],
        ['animation2', 'float', 0],
        ['scale1', 'float', 0.1],
        ['scale2', 'float', 0.1],
        ['brightness1', 'float', 1],
        ['brightness2', 'float', 1],
        ['mode', 'string', 'absolute'],
    ],

    render: async (time, self, config) => {
        const {
            animation1,
            animation2,
            scale1,
            scale2,
            brightness1,
            brightness2,
            mode,
        } = { ...config }

        const dst = greyscaleBuffers[getOutputBufferId()]
        let index = 0
        if (mode === 'absolute') {
            for (let y = 0; y < 480; ++y) {
                const value1 = Math.max(noise.perlin2(animation1, y * scale1), 0) * brightness1
                const value2 = Math.max(noise.perlin2(animation2, y * scale2), 0) * brightness2
                const value = value1 + value2
                for (let x = 0; x < 640; ++x) {
                    dst[index++] = value
                }
            }
        } else if (mode === 'additive') {
            for (let y = 0; y < 480; ++y) {
                const value1 = Math.max(noise.perlin2(animation1, y * scale1), 0) * brightness1
                const value2 = Math.max(noise.perlin2(animation2, y * scale2), 0) * brightness2
                const value = value1 + value2
                for (let x = 0; x < 640; ++x) {
                    dst[index++] += value
                }
            }
        }
    }
}
