'use strict'

modules['horizontalBlur'] = {
    config: [
        ['passes', 'int', 1],
      ],

      render: async (frameTime, self, config) => {
        const {
          passes,
        } = { ...config }
  
        let bufferAId = getOutputBufferId()
        let bufferBId = lockBuffer()
        const blurDivisor = 1 / 3
        for (let i = 0; i < passes; ++i) {
            const src = greyscaleBuffers[bufferAId]
            const dst = greyscaleBuffers[bufferBId]
            let p = 0

            for (let y = 0; y < 480; ++y) {
                dst[p] = src[p++]
                for (let x = 1; x < 640-1; ++x) {
                    const v = src[p - 1] +
                              src[p] +
                              src[p + 1]
                    dst[p++] = v * blurDivisor
                }
                dst[p] = src[p++]
            }

            const swap = bufferBId
            bufferBId = bufferAId
            bufferAId = swap
        }
        setOutputBufferId(bufferAId)
        unlockBuffer(bufferBId)
    }
}
