'use strict'

const devSectionVisibility = JSON.parse(localStorage.getItem('devSectionVisibility')) || {}

function addDevSection (parent, titleText, contents, initiallyOpen = true) {
    const setVisibleState = (open) => {
        header.innerText = `${open ? '-' : '+'} ${titleText}`
        container.style.display = open ? '' : 'none'
        header.style.color = open ? '#ddd' :  '#ddd'
        header.style.backgroundColor = open ? '#338' :  '#335'
        devSectionVisibility[titleText] = open
        localStorage.setItem('devSectionVisibility', JSON.stringify(devSectionVisibility))
    }

    const devSection = document.createElement('div')
    devSection.style.borderStyle = 'solid'
    devSection.style.borderRadius = '5px'
    devSection.style.borderWidth = '3px'
    devSection.style.borderColor = '#000'
    devSection.style.marginBottom = '5px'
    parent.appendChild(devSection)

    const header = document.createElement('pre')
    header.style.padding = '5px'
    header.style.margin = '0px'
    header.onclick = (e) => {
        setVisibleState(!devSectionVisibility[titleText])
    }
    devSection.appendChild(header)

    const container = document.createElement('div')
    container.style.backgroundColor = '#555'
    container.style.padding = '5px'
    contents.forEach(child => {
        container.append(child)
    })
    devSection.appendChild(container)

    const startOpen = devSectionVisibility[titleText] !== undefined ? devSectionVisibility[titleText] : initiallyOpen
    setVisibleState(startOpen)
}

function isDevSectionVisible (sectionName) {
    return devSectionVisibility[sectionName]
}
