-- Med-Res Thug Gen by Exocet
-- Started 25 Nov 2019 - completed August 2021
-- Random face generator

function love.load()

  love.window.setMode(640, 200)
  love.graphics.setBackgroundColor(0.5625, 0.28125, 0.28125)

  math.randomseed(os.time())

  love.filesystem.setIdentity("thug_gen_screenshots")
  -- screenshots location 	C:\Users\user\AppData\Roaming\LOVE

  imgBackground = love.graphics.newImage('img/background.png')

  imgFace = {}
  imgFace[1] = love.graphics.newImage('img/face-01.png')
  imgFace[2] = love.graphics.newImage('img/face-02.png')
  imgFace[3] = love.graphics.newImage('img/face-03.png')
  imgFace[4] = love.graphics.newImage('img/face-04.png')
  imgFace[5] = love.graphics.newImage('img/face-05.png')
  imgFace[6] = love.graphics.newImage('img/face-06.png')
  imgFace[7] = love.graphics.newImage('img/face-07.png')
  imgFace[8] = love.graphics.newImage('img/face-08.png')
  imgFace[9] = love.graphics.newImage('img/face-09.png')
  imgFace[10] = love.graphics.newImage('img/face-10.png')
  imgFace[11] = love.graphics.newImage('img/face-11.png')
  imgFace[12] = love.graphics.newImage('img/face-12.png')

  imgEye = {}
  imgEye[1] = love.graphics.newImage('img/eye-01.png')
  imgEye[2] = love.graphics.newImage('img/eye-02.png')
  imgEye[3] = love.graphics.newImage('img/eye-03.png')
  imgEye[4] = love.graphics.newImage('img/eye-04.png')
  imgEye[5] = love.graphics.newImage('img/eye-05.png')
  imgEye[6] = love.graphics.newImage('img/eye-06.png')
  imgEye[7] = love.graphics.newImage('img/eye-07.png')
  imgEye[8] = love.graphics.newImage('img/eye-08.png')
  imgEye[9] = love.graphics.newImage('img/eye-09.png')
  imgEye[10] = love.graphics.newImage('img/eye-10.png')
  imgEye[11] = love.graphics.newImage('img/eye-11.png')
  imgEye[12] = love.graphics.newImage('img/eye-12.png')

  imgMouth = {}
  imgMouth[1] = love.graphics.newImage('img/mouth-01.png')
  imgMouth[2] = love.graphics.newImage('img/mouth-02.png')
  imgMouth[3] = love.graphics.newImage('img/mouth-03.png')
  imgMouth[4] = love.graphics.newImage('img/mouth-04.png')
  imgMouth[5] = love.graphics.newImage('img/mouth-05.png')
  imgMouth[6] = love.graphics.newImage('img/mouth-06.png')
  imgMouth[7] = love.graphics.newImage('img/mouth-07.png')
  imgMouth[8] = love.graphics.newImage('img/mouth-08.png')
  imgMouth[9] = love.graphics.newImage('img/mouth-09.png')
  imgMouth[10] = love.graphics.newImage('img/mouth-10.png')
  imgMouth[11] = love.graphics.newImage('img/mouth-11.png')
  imgMouth[12] = love.graphics.newImage('img/mouth-12.png')

  imgNose = {}
  imgNose[1] = love.graphics.newImage('img/nose-01.png')
  imgNose[2] = love.graphics.newImage('img/nose-02.png')
  imgNose[3] = love.graphics.newImage('img/nose-03.png')
  imgNose[4] = love.graphics.newImage('img/nose-04.png')
  imgNose[5] = love.graphics.newImage('img/nose-05.png')
  imgNose[6] = love.graphics.newImage('img/nose-06.png')
  imgNose[7] = love.graphics.newImage('img/nose-07.png')
  imgNose[8] = love.graphics.newImage('img/nose-08.png')
  imgNose[9] = love.graphics.newImage('img/nose-09.png')
  imgNose[10] = love.graphics.newImage('img/nose-10.png')
  imgNose[11] = love.graphics.newImage('img/nose-11.png')
  imgNose[12] = love.graphics.newImage('img/nose-12.png')

  listFace = {1,2,3,4,5,6,7,8,9,10,11,12}
  listEye = {1,2,3,4,5,6,7,8,9,10,11,12}
  listMouth = {1,2,3,4,5,6,7,8,9,10,11,12}
  listNose = {1,2,3,4,5,6,7,8,9,10,11,12}

  face = {}
  face.eyeLine = (imgFace[1]:getHeight() / 2) - (imgEye[1]:getHeight() / 2)

  centerX = (love.graphics.getWidth() / 2) - (imgFace[1]:getWidth() / 2)
  centerY = (love.graphics.getHeight() / 2) - (imgFace[1]:getHeight() / 2)

  --myFont = love.graphics.newFont("font/RetroGaming.ttf", 11)

 spawnThug()
 listRandomize(listFace)
 listRandomize(listEye)
 listRandomize(listMouth)
 listRandomize(listNose)

end

-- Update ----------------------------------------------------------------------

function love.update(dt)

  if love.keyboard.isDown('space') or love.mouse.isDown(1) then
    listRandomize(listFace)
    listRandomize(listEye)
    listRandomize(listMouth)
    listRandomize(listNose)
    spawnThug()
  end

  if love.keyboard.isDown('s') then
    screenshot()
  end

end

-- Draw ------------------------------------------------------------------------------

function love.draw()

  --love.graphics.setFont(myFont)

  love.graphics.draw(imgBackground, 0, 0)
  love.graphics.draw(imgFace[thug.face], centerX, centerY)
  love.graphics.draw(imgMouth[thug.mouth], centerX + thug.mouthRandom, centerY + thug.eyeLine + 1)
  love.graphics.draw(imgNose[thug.nose], centerX, centerY + thug.eyeLine + thug.noseRandom)
  love.graphics.draw(imgEye[thug.eye], centerX, centerY + thug.eyeLine)
  --love.graphics.print("ST-Med Thug Generator - spacebar or mouse button for next face, 'S' to save image", 12, 184)

end

-- Functions ------------------------------------------------------------------------------

function spawnThug()
  thug = {}
  thug.face = math.random(1,12)
  thug.eye = math.random(1,12)
  thug.nose = math.random(1,12)
  thug.mouth = math.random(1,12)
  thug.eyeLine = (imgFace[thug.face]:getHeight() / 2) - (imgEye[thug.eye]:getHeight() / 2)
  thug.noseRandom = math.random(-1,1)
  thug.mouthRandom = math.random(-4,4)
end

function screenshot()
  love.graphics.captureScreenshot(os.time() .. ".png")
end

function listRandomize(aList)
  for i = #aList, 2, -1 do
    local j = math.random(i)
    aList[i], aList[j] = aList[j], aList [i]
  end
end
