// based on original code by http://marcinignac.com/experiments/tunnel-1k/
let ca = document.getElementById("c");			
let w = ca.width;
let h = ca.height;							
let c = ca.getContext("2d")

c.font = "24px sans-serif";

let t = 0; // time

m = Math;
fs = m.sin
fc = m.cos
fm = m.max
r = m.random()

let w1 =['waiting', 'line', 'experience', 'success', 'remote entry', 'calling']
let w2 = ['blurry', 'interactive', 'distorted', 'negotiation', 'new normal']

function shuffle(array) {
  array.sort(() => Math.random() - 0.5);
}

shuffle(w1)
shuffle(w2)

function mf(max) {
  return m.floor(r*max)
}

setInterval(d, 30);

// point
function p(x,y,z) {
  return {x:x, y:y, z:z};
}	

// surface, angle, depth
function s(a, z) {
  r = w/10;
  R = w/3;
  //b = -20*fc(a*5)*fs(z + t*5);//*(0.5 + fs(t*3))
  b = -20*fc(a*5 + t);//*(0.5 + fs(z))
  return p(
    w/2 + (R * fc(a) + r*fs(z + 2*t))/z + fc(a)*b, 
    h/2 + (R * fs(a))/z + fs(a)*b					
  );
}

// quad = angle(0,2*Math.PI), angle delta, depth, depth delta
function q(a, da, z, dz) {				
  var v = [
    s(a   , z     ),
    s(a+da, z     ),
    s(a+da, z + dz),
    s(a   , z + dz)
  ];
  // draw quad
  c.beginPath();
  c.moveTo(v[0].x, v[0].y);
  for(i in v)	c.lineTo(v[i].x, v[i].y);				
  c.fill();
}

let Z = -0.60; // depth

// draw
function d() {
  t += 1/60.0;
  c.fillStyle = "#000";
  c.fillRect(0, 0, w, h);
  c.fillStyle = "#f00";					
  var n = 30.;
  var a = 0;
  var da = 2*Math.PI/n;
  var dz = 0.25;
  
  for(var z = Z + 8; z>Z; z-=dz) {				
    for(var i=0; i<n; i++) {
      fog = 1/(fm((z+0.7)-3,1));
      if (z <= 2) {
        fog = fm(0, z/2*z/2);
      }						
      var k = (205*(fog*Math.abs(fs(i/n*2*3.14+t)))) >> 0;
      k *= (0.55+0.45*fc((i/n+0.25)*Math.PI*5));
      k = k >> 0;
      c.fillStyle = "rgb("+k+","+k+","+k+")";
      q(a, da, z, dz);
      // stripes						
      if (i % 2 == 0) {
        const fl=(fs((t*2+4))+1)*200
        c.fillStyle = "rgb("+fl+","+0+","+0+")"
        q(a, da/30, z-0.21, dz)
        // pri(c,t)
      }						
      a += da;
    }
  }					
  Z -= 0.05;
  if (Z <= dz) Z += dz;

  // pri(c,t)
  centerText(c, t*16)
}

// function pri(context, value, x=10, y=10) {
//   const saved = context.fillStyle
//   context.fillStyle = '#fff'
//   context.fillText(value, x , y)
//   context.fillStyle = saved
// }

function centerText(c, tm) {
  const dim = Math.sin(tm)
  const saved = c.fillStyle
  c.fillStyle = "rgb("+dim*255+","+dim*255+","+dim*255+")"

  // pri(c, tm, 10, 10)
  // pri(c, tm*8, 10, 30)
  // pri(c, dim, 10, 50)
  // pri(c, Math.floor(tm/radian), 10, 70)

  let text = chooseText(tm)
  if (dim > 0) {
    c.fillText(text, w/2 - (text.length) * 3 , h/2 + 12)
  }
  c.fillStyle = saved
}

const radian = (360 * Math.PI) / 180

function chooseText(tm) {
  let pw = m.floor(tm/7/radian)
  const arr = [w1[pw%w1.length], 'becomes', w2[pw%w2.length], 'at', 'nevoke 2021', '', '']
  const sel = m.floor(tm/radian) % arr.length
  if ((tm/6/radian)%1 > 0.99) {
    shuffle(w1)
    shuffle(w2)
  }
  return arr[sel]
}
