#version 330 core

layout(location = 0) in vec3 vertexPosition;
layout(location = 1) in vec2 vertexTexCoord;
layout(location = 2) in vec3 vertexNormal;
layout(location = 3) in vec4 vertexColor;

out vec2 texCoord;
out float vDepth;

uniform mat4 mvp;
uniform mat4 view;
uniform mat4 model;
uniform mat4 projection;
uniform float time = 1.0f;

uniform float near = 0.1f;
uniform float far = 100.0f;

void main(void)
{
    vec4 position = vec4(vertexPosition, 1);
    position.x += sin(time*1.0f+position.z*position.y);
    position.y += cos(time*0.9f+position.z*position.y);
    position.z += sin(time*0.8f+position.z*position.y);
    //position.z = -mod(position.z+time*-4.0, far);

    gl_Position = mvp * position;

    texCoord = vertexTexCoord;
} 
