#version 330 core

layout (points) in;
layout (triangle_strip) out;
layout (max_vertices=4) out;    

uniform mat4 mvp;

uniform float particleSize = 8.1f;

out vec2 texCoord;
out float depth;
   
void main (void)
{
    vec4 vertexPosition = gl_in[0].gl_Position;

    depth = abs(vertexPosition.z)/100.0f;

    vec2 coord = vertexPosition.xy + vec2(-0.5f, -0.5f) * particleSize;
    gl_Position = mvp * vec4(coord, vertexPosition.zw);
    texCoord = vec2(0.0f, 0.0f);
    EmitVertex();

    coord = vertexPosition.xy + vec2(-0.5f, 0.5f) * particleSize;
    gl_Position = mvp * vec4(coord, vertexPosition.zw);
    texCoord = vec2(0.0f, 1.0f);
    EmitVertex();

    coord = vertexPosition.xy + vec2(0.5f, -0.5f) * particleSize;
    gl_Position = mvp * vec4(coord, vertexPosition.zw);
    texCoord = vec2(1.0f, 0.0f);
    EmitVertex();

    coord = vertexPosition.xy + vec2(0.5f, 0.5f) * particleSize;
    gl_Position = mvp * vec4(coord, vertexPosition.zw);
    texCoord = vec2(1.0f, 1.0f);
    EmitVertex();

    EndPrimitive();
}