#version 330 core

in vec2 texCoord;
out vec4 fragColor;

uniform sampler2D texture0; 
uniform sampler2D texture1; // fft

uniform vec3 iResolution;
uniform vec4 color = vec4(1);
uniform float time;

float rand(vec2 coord)
{
    return fract(sin(dot(coord.st,vec2(12.9898,78.233)+time)) * 43758.5453);
}

void main()
{
    vec2 coord = texCoord;
    

    float fftValue = texture2D(texture1, vec2(texCoord.y, 1.0)).r;
    vec2 pos = vec2(0.5,0.5);
    float lens = dot(coord-pos, coord-pos);

    vec4 color1 = color;
    float zoom = 1.5+fftValue*0.2;
    coord = texCoord*(0.5+lens*0.5)*zoom;
    if (coord.x > 1.0 || coord.y > 1.0) {
        discard;
    }

    

    fragColor += texture(texture0, coord);
    float fadeOut = 2.0+rand(coord+fftValue)*2.0;
    fragColor.rgb *= 1-lens*fadeOut;
    fragColor.a = 1.0;

    fragColor *= color;

}
