#version 330 core

#define MAX_LIGHTS 4

in vec2 texCoord;
in vec4 vertexFragColor;
in vec3 normal;
in vec3 eye;
in vec4 shadowPosition;

out vec4 fragColor;
uniform sampler2D texture0; // diffuse
uniform sampler2D texture1; // ambient / depth
uniform sampler2D texture2; // specular
uniform sampler2D texture3; // normal
uniform sampler2DShadow shadow10; // shadow
uniform vec4 color = vec4(1,1,1,1);
uniform bool enableVertexColor = false;
uniform int activeLightCount = 0;
uniform float shadowTransparency = 0.5;
uniform bool drawShadows = false;

void main(void)
{
    fragColor = color;

    if (enableVertexColor) {
        fragColor *= vertexFragColor;
    }

    fragColor *= texture(texture0, texCoord);

    fragColor = clamp(fragColor, vec4(0,0,0,0), vec4(1,1,1,1));
} 
